<div>
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item active">Basket</li>
            </ol>
        </nav>
        
        <h1 class="fw-bold mb-0">Shopping Basket</h1>
    </div>
</div>

<div class="container py-5">
    @if(count($basketItems) > 0)
        <div class="row">
            <div class="col-lg-8">
                <div class="ys-card p-4 mb-4">
                    @foreach($basketItems as $index => $basketItem)
                        <div class="row align-items-center py-3 {{ $index > 0 ? 'border-top' : '' }}">
                            <div class="col-md-2 col-3 mb-3 mb-md-0">
                                @if($basketItem['product']->primary_image)
                                    <img src="{{ Storage::url($basketItem['product']->primary_image) }}" 
                                         alt="{{ $basketItem['product']->name }}" 
                                         class="w-100 rounded">
                                @else
                                    <div class="bg-secondary rounded d-flex align-items-center justify-content-center" 
                                         style="height: 80px;">
                                        <small class="text-white">No Image</small>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="col-md-4 col-9 mb-3 mb-md-0">
                                <h5 class="fw-bold mb-1">
                                    <a href="{{ route('product.show', $basketItem['product']->slug) }}" 
                                       class="text-decoration-none" 
                                       style="color: var(--ys-text-primary);">
                                        {{ $basketItem['product']->name }}
                                    </a>
                                </h5>
                                @if($basketItem['colourway'])
                                    <small class="text-muted">Colourway: {{ $basketItem['colourway']->reference }}</small>
                                @endif
                            </div>
                            
                            <div class="col-md-2 col-6 mb-3 mb-md-0">
                                <p class="mb-0 fw-bold" style="color: var(--ys-primary);">
                                    £{{ number_format($basketItem['product']->price, 2) }}
                                </p>
                            </div>
                            
                            <div class="col-md-2 col-6 mb-3 mb-md-0">
                                <div class="input-group input-group-sm">
                                    <button class="btn btn-outline-secondary" 
                                            wire:click="updateQuantity('{{ $basketItem['key'] }}', {{ $basketItem['quantity'] - 1 }})" 
                                            type="button">-</button>
                                    <input type="text" 
                                           class="form-control text-center" 
                                           value="{{ $basketItem['quantity'] }}" 
                                           readonly>
                                    <button class="btn btn-outline-secondary" 
                                            wire:click="updateQuantity('{{ $basketItem['key'] }}', {{ $basketItem['quantity'] + 1 }})" 
                                            type="button">+</button>
                                </div>
                            </div>
                            
                            <div class="col-md-2 col-12">
                                <div class="d-flex justify-content-between align-items-center">
                                    <p class="mb-0 fw-bold h5" style="color: var(--ys-primary);">
                                        £{{ number_format($basketItem['item_total'], 2) }}
                                    </p>
                                    <button wire:click="removeItem('{{ $basketItem['key'] }}')" 
                                            class="btn btn-sm btn-outline-danger">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <polyline points="3 6 5 6 21 6"></polyline>
                                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endforeach

                    <div class="border-top pt-3 mt-3">
                        <button wire:click="clearBasket" class="btn btn-outline-secondary">
                            Clear Basket
                        </button>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="ys-card p-4 sticky-top" style="top: 100px;">
                    <h4 class="fw-bold mb-4">Order Summary</h4>
                    
                    <div class="d-flex justify-content-between mb-2">
                        <span>Subtotal:</span>
                        <span class="fw-semibold">£{{ number_format($subtotal, 2) }}</span>
                    </div>
                    
                    <div class="d-flex justify-content-between mb-3">
                        <span>Shipping:</span>
                        <span class="fw-semibold">
                            @if($shipping > 0)
                                £{{ number_format($shipping, 2) }}
                            @else
                                <span class="text-success">FREE</span>
                            @endif
                        </span>
                    </div>

                    @if($subtotal < 50 && $subtotal > 0)
                        <div class="alert alert-info small mb-3">
                            Spend £{{ number_format(50 - $subtotal, 2) }} more for free shipping!
                        </div>
                    @endif
                    
                    <div class="border-top pt-3 mb-4">
                        <div class="d-flex justify-content-between">
                            <span class="h5 fw-bold">Total:</span>
                            <span class="h5 fw-bold" style="color: var(--ys-primary);">£{{ number_format($total, 2) }}</span>
                        </div>
                    </div>
                    
                    <a href="{{ route('checkout') }}" class="btn btn-ys-primary btn-lg w-100 mb-2">
                        Proceed to Checkout
                    </a>
                    
                    <a href="{{ route('shop.all') }}" class="btn btn-outline-secondary w-100">
                        Continue Shopping
                    </a>
                </div>
            </div>
        </div>
    @else
        <div class="text-center py-5">
            <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mb-3" style="color: var(--ys-gray);">
                <circle cx="9" cy="21" r="1"></circle>
                <circle cx="20" cy="21" r="1"></circle>
                <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
            </svg>
            <h3 class="fw-bold mb-2">Your basket is empty</h3>
            <p class="text-muted mb-4">Start shopping to add items to your basket</p>
            <a href="{{ route('shop.all') }}" class="btn btn-ys-primary btn-lg">
                Browse Products
            </a>
        </div>
    @endif
</div>
</div>
