<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <h1 class="h2 fw-bold mb-4">Shopping Basket</h1>
        </div>
    </div>

    @if(count($basket) > 0)
        <div class="row">
            <div class="col-lg-8">
                <div class="ys-card p-4 mb-4">
                    @foreach($basket as $index => $item)
                        <div class="d-flex gap-3 pb-4 mb-4 @if(!$loop->last) border-bottom @endif">
                            @if($item['image'])
                                <img src="{{ Storage::url($item['image']) }}" 
                                     alt="{{ $item['name'] }}" 
                                     style="width: 120px; height: 120px; object-fit: cover; border-radius: 8px;">
                            @else
                                <div style="width: 120px; height: 120px; background-color: var(--ys-bg-tertiary); border-radius: 8px;"></div>
                            @endif

                            <div class="flex-grow-1">
                                <h5 class="fw-bold mb-2">
                                    <a href="{{ route('product', $item['slug']) }}" class="text-decoration-none" style="color: var(--ys-text-primary);">
                                        {{ $item['name'] }}
                                    </a>
                                </h5>
                                <p class="text-muted mb-3">
                                    Colourway: {{ $item['colourway_name'] }}
                                </p>
                                <div class="d-flex align-items-center gap-3">
                                    <div class="input-group" style="width: 130px;">
                                        <button class="btn btn-outline-secondary" type="button" 
                                                wire:click="updateQuantity({{ $index }}, {{ $item['quantity'] - 1 }})">
                                            -
                                        </button>
                                        <input type="number" class="form-control text-center" value="{{ $item['quantity'] }}" readonly>
                                        <button class="btn btn-outline-secondary" type="button"
                                                wire:click="updateQuantity({{ $index }}, {{ $item['quantity'] + 1 }})">
                                            +
                                        </button>
                                    </div>
                                    <button wire:click="removeItem({{ $index }})" class="btn btn-link text-danger p-0">
                                        Remove
                                    </button>
                                </div>
                            </div>

                            <div class="text-end">
                                <p class="fw-bold mb-0" style="color: var(--ys-primary);">
                                    £{{ number_format($item['price'] * $item['quantity'], 2) }}
                                </p>
                                <small class="text-muted">£{{ number_format($item['price'], 2) }} each</small>
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="d-flex gap-2">
                    <a href="{{ route('collections') }}" class="btn btn-ys-secondary">
                        Continue Shopping
                    </a>
                    <button wire:click="clearBasket" class="btn btn-outline-danger">
                        Clear Basket
                    </button>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="ys-card p-4 sticky-top" style="top: 100px;">
                    <h5 class="fw-bold mb-4">Order Summary</h5>
                    
                    <div class="d-flex justify-content-between mb-2">
                        <span class="text-muted">Subtotal</span>
                        <span>£{{ number_format($subtotal, 2) }}</span>
                    </div>
                    
                    <div class="d-flex justify-content-between mb-3">
                        <span class="text-muted">VAT (20%)</span>
                        <span>£{{ number_format($tax, 2) }}</span>
                    </div>
                    
                    <hr>
                    
                    <div class="d-flex justify-content-between mb-4">
                        <span class="fw-bold">Total</span>
                        <span class="fw-bold h5 mb-0" style="color: var(--ys-primary);">
                            £{{ number_format($total, 2) }}
                        </span>
                    </div>

                    @auth
                        <button class="btn btn-ys-primary w-100 mb-3">
                            Proceed to Checkout
                        </button>
                    @else
                        <a href="{{ route('login') }}" class="btn btn-ys-primary w-100 mb-3">
                            Login to Checkout
                        </a>
                        <p class="text-center text-muted small mb-0">
                            or <a href="{{ route('register') }}" class="text-primary">create an account</a>
                        </p>
                    @endauth
                </div>
            </div>
        </div>
    @else
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="ys-card p-5 text-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="var(--ys-text-muted)" class="mb-3" viewBox="0 0 16 16">
                        <path d="M0 1.5A.5.5 0 0 1 .5 1H2a.5.5 0 0 1 .485.379L2.89 3H14.5a.5.5 0 0 1 .491.592l-1.5 8A.5.5 0 0 1 13 12H4a.5.5 0 0 1-.491-.408L2.01 3.607 1.61 2H.5a.5.5 0 0 1-.5-.5zM3.102 4l1.313 7h8.17l1.313-7H3.102zM5 12a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm7 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm-7 1a1 1 0 1 1 0 2 1 1 0 0 1 0-2zm7 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
                    </svg>
                    <h3 class="h4 fw-bold mb-3">Your basket is empty</h3>
                    <p class="text-muted mb-4">Start adding some beautiful yarns to your collection</p>
                    <a href="{{ route('collections') }}" class="btn btn-ys-primary btn-lg">
                        Browse Collections
                    </a>
                </div>
            </div>
        </div>
    @endif
</div>
