<div>
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item active">Basket</li>
            </ol>
        </nav>
        
        <h1 class="fw-bold mb-0">Shopping Basket</h1>
    </div>
</div>

<div class="container py-5">
    @if(count($basketItems) > 0)
        <div class="row align-items-start g-4">
            <div class="col-lg-8 basket-items-wrapper">
                <div class="ys-card p-4">
                    @foreach($basketItems as $index => $basketItem)
                        <div class="row align-items-center py-3 {{ $index > 0 ? 'border-top' : '' }}" style="min-height: 100px;">
                            <div class="col-md-2 col-3 d-flex align-items-center">
                                @php
                                    $basketImage = $basketItem['product']->primary_image;
                                    if (!$basketImage && $basketItem['colourway'] && $basketItem['colourway']->image) {
                                        $basketImage = $basketItem['colourway']->image;
                                    } elseif (!$basketImage && $basketItem['product']->colourways && $basketItem['product']->colourways->count() > 0) {
                                        $colourwayWithImage = $basketItem['product']->colourways->firstWhere('image', '!=', null);
                                        if ($colourwayWithImage) {
                                            $basketImage = $colourwayWithImage->image;
                                        }
                                    }
                                @endphp
                                @if($basketImage)
                                    <div style="width: 100%; aspect-ratio: 1 / 1; overflow: hidden; border-radius: 0.375rem; display: block; line-height: 0;">
                                        <img src="{{ Storage::url($basketImage) }}" 
                                             alt="{{ $basketItem['product']->name }}" 
                                             class="w-100 rounded"
                                             style="width: 100%; height: 100%; object-fit: cover; display: block;">
                                    </div>
                                @else
                                    <div class="placeholder-box rounded" 
                                         style="width: 100%; aspect-ratio: 1 / 1; display: flex; align-items: center; justify-content: center;">
                                        <small>No Image</small>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="col-md-4 col-9 d-flex flex-column justify-content-center">
                                <h5 class="fw-bold mb-1">
                                    <a href="{{ route('product.show', $basketItem['product']->slug) }}" 
                                       class="text-decoration-none" 
                                       style="color: var(--ys-text-primary);">
                                        {{ $basketItem['product']->name }}
                                    </a>
                                </h5>
                                @if($basketItem['colourway'])
                                    <small class="text-muted">Colourway: {{ $basketItem['colourway']->reference }}</small>
                                @endif
                            </div>
                            
                            <div class="col-md-2 col-6 d-flex align-items-center">
                                <p class="mb-0 fw-bold w-100 text-center text-md-start" style="color: var(--ys-primary);">
                                    £{{ number_format($basketItem['product']->price, 2) }}
                                </p>
                            </div>
                            
                            <div class="col-md-2 col-6 d-flex align-items-center justify-content-center">
                                <div class="input-group input-group-sm" style="max-width: 120px;">
                                    <button class="btn btn-outline-secondary" 
                                            wire:click="updateQuantity('{{ $basketItem['key'] }}', {{ $basketItem['quantity'] - 1 }})" 
                                            type="button">-</button>
                                    <input type="text" 
                                           class="form-control text-center" 
                                           value="{{ $basketItem['quantity'] }}" 
                                           readonly>
                                    <button class="btn btn-outline-secondary" 
                                            wire:click="updateQuantity('{{ $basketItem['key'] }}', {{ $basketItem['quantity'] + 1 }})" 
                                            type="button">+</button>
                                </div>
                            </div>
                            
                            <div class="col-md-2 col-12 d-flex align-items-center justify-content-md-end justify-content-between mt-3 mt-md-0">
                                <div class="d-flex justify-content-between align-items-center gap-2 w-100 w-md-auto">
                                    <p class="mb-0 fw-bold h5 flex-shrink-0" style="color: var(--ys-primary);">
                                        £{{ number_format($basketItem['item_total'], 2) }}
                                    </p>
                                    <button wire:click="removeItem('{{ $basketItem['key'] }}')" 
                                            class="btn btn-sm btn-outline-danger flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <polyline points="3 6 5 6 21 6"></polyline>
                                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endforeach

                    <div class="border-top pt-3 mt-3">
                        <button wire:click="clearBasket" class="btn btn-outline-secondary">
                            Clear Basket
                        </button>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 basket-summary-wrapper">
                <div class="ys-card p-4 sticky-top" style="top: 20px; z-index: 999;">
                    <h4 class="fw-bold mb-4">Order Summary</h4>
                    
                    <div class="d-flex justify-content-between mb-2">
                        <span>Subtotal:</span>
                        <span class="fw-semibold">£{{ number_format($subtotal, 2) }}</span>
                    </div>
                    
                    <div class="d-flex justify-content-between mb-3">
                        <span>Shipping:</span>
                        <span class="fw-semibold">
                            £{{ number_format($shipping, 2) }}
                        </span>
                    </div>
                    
                    <div class="mb-3 p-3 rounded" style="background: linear-gradient(135deg, rgba(var(--bs-primary-rgb), 0.1) 0%, rgba(var(--bs-primary-rgb), 0.05) 100%); border: 2px solid var(--ys-primary); box-shadow: 0 2px 8px rgba(0,0,0,0.05);">
                        <div class="d-flex align-items-start mb-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="color: var(--ys-primary); flex-shrink: 0; margin-right: 0.5rem;">
                                <circle cx="12" cy="12" r="10"></circle>
                                <line x1="12" y1="16" x2="12" y2="12"></line>
                                <line x1="12" y1="8" x2="12.01" y2="8"></line>
                            </svg>
                            <div>
                                <h6 class="fw-bold mb-2" style="color: var(--ys-primary);">Important: Made to Order</h6>
                                <p class="mb-0 small">All yarn is spun to order by our spinners worldwide, ensuring you receive the freshest, highest quality yarns. <strong>The weight of yarn is not exact and may vary slightly from what you order. When your yarn is spun and weighed, you will be invoiced for the actual weight received.</strong> Delivery times vary based on production schedules and spinner location - we'll keep you updated throughout the process.</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="border-top pt-3 mb-4">
                        <div class="d-flex justify-content-between">
                            <span class="h5 fw-bold">Total:</span>
                            <span class="h5 fw-bold" style="color: var(--ys-primary);">£{{ number_format($total, 2) }}</span>
                        </div>
                    </div>
                    
                    <a href="{{ route('checkout') }}" class="btn btn-ys-primary btn-lg w-100 mb-2">
                        Proceed to Checkout
                    </a>
                    
                    <a href="{{ route('shop.all') }}" class="btn btn-outline-secondary w-100">
                        Continue Shopping
                    </a>
                </div>
            </div>
        </div>
    @else
        <div class="text-center py-5">
            <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mb-3" style="color: var(--ys-gray);">
                <circle cx="9" cy="21" r="1"></circle>
                <circle cx="20" cy="21" r="1"></circle>
                <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
            </svg>
            <h3 class="fw-bold mb-2">Your basket is empty</h3>
            <p class="text-muted mb-4">Start shopping to add items to your basket</p>
            <a href="{{ route('shop.all') }}" class="btn btn-ys-primary btn-lg">
                Browse Products
            </a>
        </div>
    @endif
</div>
</div>
