<div class="bg-white border-bottom">
    <div class="px-4 py-3">
        <div class="d-flex justify-content-between align-items-center">
            <div class="d-flex align-items-center">
                <i class="fas fa-tachometer-alt text-primary me-3 fs-2"></i>
                <h1 class="fs-3 fw-bold text-dark mb-0">Dashboard</h1>
            </div>
            <div class="d-flex gap-2 align-items-center">
                <!-- Season Filter -->
                <div class="d-flex align-items-center gap-2">
                    <label class="form-label mb-0 fw-semibold text-muted">Season:</label>
                    <select 
                        wire:model.live="selectedSeason" 
                        class="form-select form-select-sm"
                        style="min-width: 140px;"
                        wire:loading.attr="disabled"
                    >
                        @foreach($seasons as $season)
                            <option value="{{ $season->id }}">{{ $season->description }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Order Type Filter -->
                <div class="d-flex align-items-center gap-2">
                    <label class="form-label mb-0 fw-semibold text-muted">Order Type:</label>
                    <select 
                        wire:model.live="selectedOrderType" 
                        class="form-select form-select-sm"
                        style="min-width: 120px;"
                        wire:loading.attr="disabled"
                    >
                        @foreach($orderTypes as $value => $label)
                            <option value="{{ $value }}">{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                
                <!-- Refresh Button -->
                <button 
                    wire:click="refreshDashboard" 
                    class="btn btn-outline-primary btn-sm"
                    wire:loading.attr="disabled"
                    title="Clear cache and refresh all data"
                >
                    <i class="fas fa-sync-alt" wire:loading.class="fa-spin"></i>
                    <span class="d-none d-sm-inline ms-1">Refresh</span>
                </button>
            </div>
        </div>
    </div>
</div>
