<div>
    @if($isLoading)
        <div class="row g-3">
            @for($i = 0; $i < 5; $i++)
                <div class="col-sm-6 col-lg-2">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body text-center">
                            <div class="text-muted mb-2">
                                <div class="spinner-border spinner-border-sm" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                            <h5 class="card-title text-muted mb-1">Loading...</h5>
                            <h3 class="text-muted mb-0">-</h3>
                        </div>
                    </div>
                </div>
            @endfor
        </div>
    @else
        <div class="row g-3">
            <!-- Total Styles in Season -->
            <div class="col-sm-6 col-lg-2">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center">
                        <div class="text-info mb-2">
                            <i class="fas fa-palette fs-1"></i>
                        </div>
                        <h5 class="card-title text-muted mb-1">Styles</h5>
                        <h3 class="text-info mb-0">{{ number_format($totalStylesInSeason) }}</h3>
                        <small class="text-muted">In orders</small>
                    </div>
                </div>
            </div>

            <!-- Total GMTs Shipped -->
            <div class="col-sm-6 col-lg-2">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center">
                        <div class="text-success mb-2">
                            <i class="fas fa-shipping-fast fs-1"></i>
                        </div>
                        <h5 class="card-title text-muted mb-1">GMTs Shipped</h5>
                        <h3 class="text-success mb-0">{{ number_format($totalQmtsShipped) }}</h3>
                        <small class="text-muted">Total shipped</small>
                    </div>
                </div>
            </div>

            <!-- Total GMTs Left to Ship -->
            <div class="col-sm-6 col-lg-2">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center">
                        <div class="text-warning mb-2">
                            <i class="fas fa-clock fs-1"></i>
                        </div>
                        <h5 class="card-title text-muted mb-1">GMTs Left</h5>
                        <h3 class="text-warning mb-0">{{ number_format($totalGmtsLeftToShip) }}</h3>
                        <small class="text-muted">Remaining to ship</small>
                    </div>
                </div>
            </div>

            <!-- Value Shipped Percentage -->
            <div class="col-sm-6 col-lg-2">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center">
                        <div class="text-primary mb-2">
                            <i class="fas fa-percentage fs-1"></i>
                        </div>
                        <h5 class="card-title text-muted mb-1">Value Shipped</h5>
                        <h3 class="text-primary mb-0">{{ $valueShippedPercentage }}%</h3>
                        <small class="text-muted">£{{ number_format($totalValueShipped, 0) }} of £{{ number_format($totalValueOrdered, 0) }}</small>
                    </div>
                </div>
            </div>

            <!-- Total Samples Sent -->
            <div class="col-sm-6 col-lg-2">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center">
                        <div class="text-info mb-2">
                            <i class="fas fa-box fs-1"></i>
                        </div>
                        <h5 class="card-title text-muted mb-1">Samples Sent</h5>
                        <h3 class="text-info mb-0">{{ number_format($totalSamplesSent) }}</h3>
                        <small class="text-muted">Total samples</small>
                    </div>
                </div>
            </div>

            <!-- Total Invoices Sent -->
            <div class="col-sm-6 col-lg-2">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-body text-center">
                        <div class="text-secondary mb-2">
                            <i class="fas fa-file-invoice fs-1"></i>
                        </div>
                        <h5 class="card-title text-muted mb-1">Invoices Sent</h5>
                        <h3 class="text-secondary mb-0">{{ number_format($totalInvoicesSent) }}</h3>
                        <small class="text-muted">Total invoices</small>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
