@extends('layouts.shop')

@section('title', 'Cookie Policy - Yarn Store')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">Cookie Policy</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="ys-card p-4">
                <p class="text-muted small mb-4">Last updated: {{ date('F d, Y') }}</p>

                <h3 class="fw-bold mb-3">What Are Cookies?</h3>
                <p>Cookies are small text files stored on your device when you visit our website. They help us provide you with a better experience and allow certain features to function.</p>

                <h3 class="fw-bold mb-3 mt-4">Types of Cookies We Use</h3>
                
                <h5 class="fw-bold mt-4">1. Essential Cookies</h5>
                <p>These cookies are necessary for the website to function and cannot be disabled:</p>
                <ul>
                    <li><strong>Session cookies:</strong> Keep you logged in</li>
                    <li><strong>Basket cookies:</strong> Remember items in your shopping basket</li>
                    <li><strong>Security cookies:</strong> Protect your session</li>
                </ul>

                <h5 class="fw-bold mt-4">2. Functional Cookies</h5>
                <p>These cookies enhance functionality and personalization:</p>
                <ul>
                    <li>Remember your preferences</li>
                    <li>Store your cookie consent choice</li>
                    <li>Remember your login details (if selected)</li>
                </ul>

                <h5 class="fw-bold mt-4">3. Analytics Cookies</h5>
                <p>These help us understand how visitors use our website:</p>
                <ul>
                    <li>Google Analytics (anonymized)</li>
                    <li>Page view tracking</li>
                    <li>User journey analysis</li>
                </ul>

                <h5 class="fw-bold mt-4">4. Marketing Cookies</h5>
                <p>These cookies track your browsing to show relevant advertisements:</p>
                <ul>
                    <li>Social media pixels</li>
                    <li>Retargeting cookies</li>
                    <li>Ad performance tracking</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-4">Managing Cookies</h3>
                <p>You can control cookies through:</p>
                <ul>
                    <li>Our cookie consent banner</li>
                    <li>Your browser settings</li>
                    <li>Third-party opt-out tools</li>
                </ul>
                <p>Note: Disabling essential cookies may affect website functionality.</p>

                <h3 class="fw-bold mb-3 mt-4">Third-Party Cookies</h3>
                <p>Some cookies are set by third-party services we use:</p>
                <ul>
                    <li><strong>Google Analytics:</strong> Website analytics</li>
                    <li><strong>Payment Processors:</strong> Secure payment processing</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-4">Contact Us</h3>
                <p>If you have questions about our use of cookies, please contact us at info@yarnstore.co.uk</p>
            </div>
        </div>
    </div>
</div>
@endsection






