<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;

class ReceiptApiTest extends TestCase
{
    use RefreshDatabase;

    public function test_receipt_upload_endpoint_creates_receipt(): void
    {
        $user = User::factory()->create();
        $token = $user->createToken('test')->plainTextToken;

        $response = $this->withHeader('Authorization', 'Bearer '.$token)->postJson('/api/receipts', [
            'receipt_date' => '2025-05-22',
            'total_amount' => 12.34,
            'merchant_name' => 'Test Merchant',
        ]);

        $response->assertCreated();
    }
}
