<?php

return [
    'rules' => [
        'crisis' => [
            'keywords' => [
                'suicide', 'self-harm', 'harm to others', 'crisis', 'emergency',
                'kill myself', 'want to die', 'end it all'
            ],
            'action' => 'block',
            'crisis_copy' => 'If you\'re experiencing thoughts of self-harm or crisis, please contact a mental health professional or call a crisis helpline immediately. You\'re not alone, and help is available.',
        ],
        'content_moderation' => [
            'keywords' => [
                'violence', 'hate speech', 'discrimination', 'harassment'
            ],
            'action' => 'redact',
        ],
    ],
    
    'allow_lists' => [
        'therapeutic_terms' => [
            'anxiety', 'depression', 'stress', 'relaxation', 'meditation',
            'mindfulness', 'healing', 'recovery', 'wellness'
        ],
    ],
    
    'block_lists' => [
        'inappropriate_content' => [
            'explicit', 'adult', 'nsfw', 'inappropriate'
        ],
    ],
];
