<div class="max-w-5xl">
    @if (session('status'))
        <div class="mb-6 p-4 rounded-xl border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 bg-gradient-to-br from-green-50 to-green-100/50 dark:from-green-900/20 dark:to-green-800/20 flex items-start gap-3">
            <svg class="w-5 h-5 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            <div>{{ session('status') }}</div>
        </div>
    @endif

    @if (session('error'))
        <div class="mb-6 p-4 rounded-xl border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 bg-gradient-to-br from-red-50 to-red-100/50 dark:from-red-900/20 dark:to-red-800/20 flex items-start gap-3">
            <svg class="w-5 h-5 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/></svg>
            <div>{{ session('error') }}</div>
        </div>
    @endif

    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 p-8">
        <div class="mb-6">
            <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-2">Upload Receipts</h2>
            <p class="text-sm text-gray-600 dark:text-gray-400">Drag and drop receipt images or click to browse. Receipt data (date, amount, merchant) will be automatically extracted using AI.</p>
        </div>

        <!-- Drag & Drop Zone -->
        <div
            x-data="{dragging:false}"
            x-on:dragover.prevent="dragging=true"
            x-on:dragleave.prevent="dragging=false"
            x-on:drop.prevent="dragging=false; $refs.fileInput.files = $event.dataTransfer.files; $refs.fileInput.dispatchEvent(new Event('change'))"
            class="relative border-2 border-dashed rounded-2xl p-12 text-center transition-all duration-200 cursor-pointer group"
            :class="dragging ? 'border-indigo-500 bg-indigo-50/50 dark:bg-indigo-900/20 scale-[1.02]' : 'border-gray-300 dark:border-gray-600 hover:border-indigo-400 dark:hover:border-indigo-500 hover:bg-gray-50/50 dark:hover:bg-gray-700/30'"
            onclick="document.getElementById('file-upload').click()"
        >
            <input 
                id="file-upload"
                type="file" 
                multiple 
                wire:model="files"
                x-ref="fileInput"
                class="hidden"
                accept="image/*,.eml,.pdf"
            />
            
            <div class="flex flex-col items-center gap-4">
                <div class="p-4 rounded-2xl bg-gradient-to-br from-indigo-50 to-indigo-100/50 dark:from-indigo-900/30 dark:to-indigo-800/20 group-hover:scale-110 transition-transform duration-200">
                    <svg class="w-12 h-12 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
                
                <div>
                    <p class="text-base font-medium text-gray-900 dark:text-white mb-1">
                        Drop receipt files here
                    </p>
                    <p class="text-sm text-gray-500 dark:text-gray-400">
                        or <span class="text-indigo-600 dark:text-indigo-400 font-medium">click to browse</span>
                    </p>
                </div>
                
                <div class="text-xs text-gray-400 dark:text-gray-500">
                    Images (PNG, JPG, JPEG), EML, PDF up to 10MB each
                </div>
            </div>

            <div 
                wire:loading 
                wire:target="files" 
                class="absolute inset-0 bg-white/80 dark:bg-gray-800/80 backdrop-blur-sm rounded-2xl flex items-center justify-center"
            >
                <div class="flex flex-col items-center gap-3">
                    <svg class="animate-spin h-8 w-8 text-indigo-600" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Uploading files...</span>
                </div>
            </div>
        </div>

        @error('files.*')
        <div class="mt-3 text-sm text-red-600 dark:text-red-400 flex items-center gap-2">
            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
            {{ $message }}
        </div>
        @enderror

        <!-- File Preview Grid -->
        @if ($files)
        <div class="mt-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-sm font-medium text-gray-900 dark:text-white">
                    Selected Files ({{ count($files) }})
                </h3>
                <button 
                    wire:click="$set('files', [])" 
                    class="text-xs text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors"
                >
                    Clear all
                </button>
            </div>
            
            <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-4 gap-4">
                @foreach ($files as $i => $f)
                    <div class="group relative bg-gray-50 dark:bg-gray-700/50 border border-gray-200 dark:border-gray-600 rounded-xl p-3 hover:shadow-md transition-all duration-200">
                        <div class="flex items-start gap-3">
                            <div class="flex-shrink-0 p-2 bg-indigo-100 dark:bg-indigo-900/30 rounded-lg">
                                <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                </svg>
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="text-sm font-medium text-gray-900 dark:text-white truncate" title="{{ $f->getClientOriginalName() }}">
                                    {{ $f->getClientOriginalName() }}
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                    {{ number_format($f->getSize()/1024,1) }} KB
                                </div>
                            </div>
                        </div>
                        
                        <!-- Success indicator -->
                        <div class="absolute top-2 right-2 opacity-0 group-hover:opacity-100 transition-opacity">
                            <div class="w-6 h-6 rounded-full bg-green-100 dark:bg-green-900/30 flex items-center justify-center">
                                <svg class="w-4 h-4 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        @endif

        <!-- Action Buttons -->
        @if ($files && count($files) > 0)
        <div class="flex items-center justify-between mt-6 pt-6 border-t border-gray-200 dark:border-gray-700">
            <div class="text-sm text-gray-600 dark:text-gray-400">
                Ready to upload {{ count($files) }} {{ count($files) === 1 ? 'file' : 'files' }}
                <!-- Debug info -->
                <div class="text-xs text-gray-500 mt-1">
                    Files: {{ json_encode(array_map(fn($f) => $f->getClientOriginalName(), $files)) }}
                </div>
            </div>
            <button 
                wire:click="saveUploads" 
                class="inline-flex items-center gap-2 px-6 py-3 rounded-xl bg-gradient-to-r from-indigo-600 to-indigo-700 text-white font-medium hover:from-indigo-700 hover:to-indigo-800 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition-all shadow-sm hover:shadow-md disabled:opacity-50 disabled:cursor-not-allowed"
                wire:loading.attr="disabled"
                wire:target="saveUploads"
                @disabled(!(isset($files) && count($files) > 0))
            >
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                </svg>
                <span wire:loading.remove wire:target="saveUploads">Upload All</span>
                <span wire:loading wire:target="saveUploads">Processing...</span>
            </button>
        </div>
        @endif
    </div>
</div>


