<div class="max-w-5xl">
    @if (session('status'))
        <div class="mb-4 p-3 rounded border border-green-200 text-green-800 bg-green-50">
            {{ session('status') }}
        </div>
    @endif

    <div
        x-data="{dragging:false}"
        x-on:dragover.prevent="dragging=true"
        x-on:dragleave.prevent="dragging=false"
        x-on:drop.prevent="dragging=false"
        class="border-2 border-dashed rounded-lg p-6 text-center"
        :class="dragging ? 'border-indigo-500 bg-indigo-50 dark:bg-indigo-900/20' : 'border-gray-300 dark:border-gray-700'"
    >
        <div class="text-sm text-gray-600 dark:text-gray-300">Drag and drop receipts here, or click to select</div>
        <input type="file" multiple wire:model="files" class="mt-3" />
        <div wire:loading wire:target="files" class="text-sm text-gray-500 mt-2">Uploading...</div>
    </div>

    @error('files.*')
    <div class="text-sm text-red-600 mt-2">{{ $message }}</div>
    @enderror

    @if ($files)
    <div class="mt-4 grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3">
        @foreach ($files as $i => $f)
            <div class="border rounded p-2 text-sm">
                <div class="truncate">{{ $f->getClientOriginalName() }}</div>
                <div class="text-xs text-gray-500">{{ number_format($f->getSize()/1024,1) }} KB</div>
            </div>
        @endforeach
    </div>
    @endif

    <div class="mt-4">
        <button wire:click="upload" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500">Upload</button>
    </div>
</div>


