<?php

namespace App\Http\Controllers;

use App\Services\LibraryService;
use Illuminate\Http\Request;

class LibraryController extends Controller
{
    public function __construct(
        private LibraryService $libraryService
    ) {}

    public function index(Request $request)
    {
        $filters = $request->only(['category_id', 'voice_type', 'difficulty', 'search']);
        $categories = $this->libraryService->getCategories();
        $tracks = $this->libraryService->getTracks($filters);
        $popularTracks = $this->libraryService->getPopularTracks();
        
        return view('library.index', compact('categories', 'tracks', 'popularTracks', 'filters'));
    }

    public function show(string $slug)
    {
        $track = $this->libraryService->getTrack($slug);
        
        if (!$track) {
            abort(404);
        }
        
        $relatedTracks = $this->libraryService->getTracksByCategory($track->category_id, 4);
        
        return view('library.show', compact('track', 'relatedTracks'));
    }
}
