<?php

namespace App\Http\Controllers;

use App\Services\LibraryService;
use Illuminate\Http\Request;

class LibraryController extends Controller
{
    public function __construct(
        private LibraryService $libraryService
    ) {}

    public function index(Request $request)
    {
        $categories = $this->libraryService->getCategories();
        
        $filters = [
            'category_id' => $request->get('category'),
            'voice_type' => $request->get('voice'),
            'difficulty' => $request->get('difficulty'),
            'search' => $request->get('search'),
        ];

        $tracks = $this->libraryService->getTracks(
            $filters['category_id'],
            $filters['voice_type'],
            $filters['difficulty'],
            $filters['search'],
            12
        );

        return view('library.index', compact('categories', 'tracks', 'filters'));
    }

    public function show(string $slug)
    {
        $track = $this->libraryService->getTrackBySlug($slug);
        
        if (!$track) {
            abort(404);
        }

        // Increment play count
        $this->libraryService->incrementPlayCount($track);

        // Get related tracks from the same category
        $relatedTracks = $this->libraryService->getTracks(
            $track->category_id,
            null,
            null,
            null,
            6
        );

        return view('library.show', compact('track', 'relatedTracks'));
    }
}
