<?php

namespace App\Http\Controllers\Api\V1;

use App\Contracts\ProfileService;
use App\Http\Controllers\Controller;
use App\Http\Requests\ProfileUpdateRequest;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    public function __construct(private readonly ProfileService $profiles)
    {
        $this->middleware(['auth:sanctum']);
    }

    public function show(Request $request)
    {
        $user = $request->user()->load('profile');
        return response()->json($user->profile);
    }

    public function update(ProfileUpdateRequest $request)
    {
        $profile = $this->profiles->updateProfile($request->user(), $request->validated());
        return response()->json($profile);
    }
}


