<?php

namespace App\Http\Controllers\Api\V1;

use App\Contracts\ProfileService;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    public function __construct(private readonly ProfileService $profiles)
    {
    }

    public function show(Request $request)
    {
        return response()->json(optional($request->user()->load('profile'))->profile);
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'display_name' => ['nullable', 'string', 'max:120'],
            'preferences' => ['sometimes', 'array'],
            'sensitivity' => ['sometimes', 'array'],
        ]);
        $profile = $this->profiles->updateProfile($request->user(), $validated);
        return response()->json($profile);
    }
}


