<div>
    <!-- Statements to Complete -->
    <div class="mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-sm border border-gray-100 dark:border-gray-700">
            <div class="flex items-center gap-4 mb-6">
                <div class="p-4 bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-2xl shadow-lg">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                    </svg>
                </div>
                <div>
                    <h2 class="text-2xl font-bold text-gray-900 dark:text-white">
                        Statements to Complete: <span class="text-indigo-600 dark:text-indigo-400">{{ str_pad($statementsToComplete, 2, '0', STR_PAD_LEFT) }}</span>
                    </h2>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Review and match receipts to complete these statements</p>
                </div>
            </div>

            @if ($hasMore)
                <div class="flex items-center justify-between text-sm text-gray-600 dark:text-gray-400">
                    <span>Showing soonest period ends first</span>
                    <button wire:click="$parent.setTab('statements')" class="text-indigo-600 dark:text-indigo-400 hover:underline">View all</button>
                </div>
            @endif
        </div>
    </div>

    <!-- Incomplete Statements List -->
    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Incomplete Statements</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Statements that need receipts matched and review</p>
        </div>

        <div class="divide-y divide-gray-200 dark:divide-gray-700">
            @forelse ($incompleteStatements as $statement)
                @php
                    $matchedCount = $statement->matched_count ?? 0;
                    $totalCount = $statement->total_count ?? 0;
                    $percentage = $totalCount > 0 ? round(($matchedCount / $totalCount) * 100) : 0;
                @endphp
                <div class="p-6 hover:bg-gray-50 dark:hover:bg-gray-700/30 transition-colors">
                    <div class="flex items-center justify-between gap-6">
                        <!-- Statement Info -->
                        <div class="flex items-center gap-4 flex-1">
                            <div class="p-3 bg-indigo-50 dark:bg-indigo-900/30 rounded-xl">
                                <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                </svg>
                            </div>
                            <div class="flex-1">
                                <div class="flex items-center gap-3 mb-1">
                                    <h4 class="font-semibold text-gray-900 dark:text-white">
                                        {{ $statement->period_start?->format('F Y') }}
                                    </h4>
                                    <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-xs font-medium bg-amber-100 dark:bg-amber-900/30 text-amber-800 dark:text-amber-300">
                                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 8 8"><circle cx="4" cy="4" r="3"/></svg>
                                        Incomplete
                                    </span>
                                </div>
                                <div class="flex items-center gap-4 text-sm text-gray-600 dark:text-gray-400">
                                    <span class="flex items-center gap-1.5">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                        </svg>
                                        {{ $statement->cardholder_name }}
                                    </span>
                                    <span class="flex items-center gap-1.5">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                                        </svg>
                                        {{ $statement->account_number_masked }}
                                    </span>
                                    <span class="text-xs">
                                        {{ $statement->period_start?->format('d M') }} - {{ $statement->period_end?->format('d M Y') }}
                                    </span>
                                    @php
                                        $daysRemaining = now()->diffInDays(optional($statement->period_end)->endOfDay(), false);
                                    @endphp
                                    <span class="inline-flex items-center gap-1.5 text-xs px-2 py-0.5 rounded-full {{ $daysRemaining <= 3 ? 'bg-red-100 dark:bg-red-900/30 text-red-700 dark:text-red-300' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300' }}">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3"/></svg>
                                        {{ $daysRemaining >= 0 ? $daysRemaining.' days left' : abs($daysRemaining).' days overdue' }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Progress -->
                        <div class="flex items-center gap-6">
                            <div class="min-w-[200px]">
                                <div class="flex items-center justify-between text-xs mb-2">
                                    <span class="text-gray-600 dark:text-gray-400">Matched</span>
                                    <span class="font-semibold text-gray-900 dark:text-white">{{ $matchedCount }}/{{ $totalCount }}</span>
                                </div>
                                <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2 overflow-hidden">
                                    <div 
                                        class="h-full rounded-full transition-all duration-300 {{ $percentage >= 100 ? 'bg-green-500' : ($percentage >= 50 ? 'bg-indigo-500' : 'bg-amber-500') }}"
                                        style="width: {{ $percentage }}%"
                                    ></div>
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1 text-right">{{ $percentage }}% complete</div>
                            </div>

                            <!-- Action Button -->
                            <button 
                                wire:click="$parent.selectStatement({{ $statement->id }})" 
                                class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl bg-gradient-to-r from-indigo-600 to-indigo-700 text-white font-medium hover:from-indigo-700 hover:to-indigo-800 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition-all shadow-sm hover:shadow-md whitespace-nowrap"
                            >
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/>
                                </svg>
                                Review
                            </button>
                        </div>
                    </div>
                </div>
            @empty
                <div class="px-6 py-16 text-center">
                    <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-gradient-to-br from-green-50 to-green-100 dark:from-green-900/20 dark:to-green-800/20 flex items-center justify-center">
                        <svg class="w-10 h-10 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">All caught up!</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">You have no incomplete statements at this time.</p>
                    <button 
                        wire:click="$parent.setTab('import')" 
                        class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl bg-gradient-to-r from-indigo-600 to-indigo-700 text-white font-medium hover:from-indigo-700 hover:to-indigo-800 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition-all"
                    >
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                        </svg>
                        Import New Statement
                    </button>
                </div>
            @endforelse
        </div>
    </div>
</div>

