<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Season;
use Illuminate\Http\Request;

class SeasonController extends Controller
{
    public function index()
    {
        $seasons = Season::orderByDesc('year')->orderBy('half')->paginate(20);
        return view('admin.seasons.index', compact('seasons'));
    }

    public function create()
    {
        return view('admin.seasons.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'code' => 'required|string|max:10|unique:seasons,code',
            'half' => 'required|in:AW,SS',
            'year' => 'required|integer|min:2000|max:2100',
            'label' => 'nullable|string|max:60',
            'description' => 'nullable|string',
            'image_path' => 'nullable|url',
            'starts_on' => 'nullable|date',
            'ends_on' => 'nullable|date|after_or_equal:starts_on',
            'is_active' => 'boolean',
        ]);

        $data['is_active'] = $request->boolean('is_active');
        Season::create($data);

        return redirect()->route('admin.seasons.index')->with('status', 'Season created');
    }

    public function edit(Season $season)
    {
        return view('admin.seasons.edit', compact('season'));
    }

    public function update(Request $request, Season $season)
    {
        $data = $request->validate([
            'code' => 'required|string|max:10|unique:seasons,code,'.$season->id,
            'half' => 'required|in:AW,SS',
            'year' => 'required|integer|min:2000|max:2100',
            'label' => 'nullable|string|max:60',
            'description' => 'nullable|string',
            'image_path' => 'nullable|url',
            'starts_on' => 'nullable|date',
            'ends_on' => 'nullable|date|after_or_equal:starts_on',
            'is_active' => 'boolean',
        ]);

        $data['is_active'] = $request->boolean('is_active');
        $season->update($data);

        return redirect()->route('admin.seasons.index')->with('status', 'Season updated');
    }

    public function destroy(Season $season)
    {
        $season->delete();
        return redirect()->route('admin.seasons.index')->with('status', 'Season deleted');
    }
}


