<?php
$meta = [
  'title' => 'Custom ERP for Manufacturing | Case Study',
  'description' => 'Designed and led a Laravel-based ERP covering products, pricing, sales, manufacturing, financial reporting and AI LLM tooling.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/robert-todd-erp.php'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">Custom ERP for Manufacturing</h1>
    <p class="mt-2 text-sm text-gray-600">Lead Software Developer at Robert Todd &amp; Son Ltd (2020–now)</p>

    <div class="mt-6 grid gap-6 md:grid-cols-2">
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Scope</h2>
        <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
          <li>End‑to‑end ERP: products, development, pricing, sales, manufacturing.</li>
          <li>Financial reporting, advanced SQL, and automated data seeding.</li>
          <li>AI LLM assistants to streamline estimation and documentation.</li>
        </ul>
      </div>
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Tech & Approach</h2>
        <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
          <li>Laravel 12, Livewire; JS/TS, HTML, SCSS.</li>
          <li>Microservice‑oriented PHP; CI/CD and Agile delivery.</li>
          <li>Deployed on Google Cloud Platform; transferable to AWS ECS/EC2.</li>
        </ul>
      </div>
    </div>

    <div class="card p-4 mt-6">
      <h2 class="font-semibold text-gray-900">Outcome</h2>
      <p class="mt-2 text-sm text-gray-700">Unified workflows and real‑time reporting improved visibility and speed of decision‑making across departments. Features are continuously expanded to new business areas.</p>
    </div>

    <div class="mt-6">
      <a href="/portfolio/" class="btn-secondary">Back to portfolio</a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>


