<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">Items</h1>
            <p class="text-muted mb-0">Manage your product catalog</p>
        </div>
        <button class="btn btn-primary">
            <i class="bi bi-plus-lg me-2"></i>Add Item
        </button>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Search Items</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-search"></i>
                        </span>
                        <input type="text" 
                               wire:model.live.debounce.300ms="search" 
                               class="form-control" 
                               placeholder="Search by name, description, or SKU...">
                    </div>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Season</label>
                    <select wire:model.live="seasonFilter" class="form-select">
                        <option value="">All Seasons</option>
                        @foreach($seasons as $season)
                            <option value="{{ $season->id }}">{{ $season->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Category</label>
                    <select wire:model.live="categoryFilter" class="form-select">
                        <option value="">All Categories</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select wire:model.live="statusFilter" class="form-select">
                        <option value="">All Statuses</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Per Page</label>
                    <select wire:model.live="perPage" class="form-select">
                        <option value="12">12</option>
                        <option value="24">24</option>
                        <option value="48">48</option>
                    </select>
                </div>
                
                <div class="col-md-1 d-flex align-items-end">
                    @if($search || $seasonFilter || $categoryFilter || $statusFilter)
                        <button wire:click="$set('search', ''); $set('seasonFilter', ''); $set('categoryFilter', ''); $set('statusFilter', '')" 
                                class="btn btn-outline-secondary">
                            <i class="bi bi-x-lg"></i>
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Items Grid -->
    @if($items->count() > 0)
        <div class="row g-4">
            @foreach($items as $item)
                <div class="col-lg-3 col-md-4 col-sm-6">
                    <div class="card h-100 cursor-pointer">
                        <div class="position-relative">
                            @if($item->primary_image)
                                <img src="{{ $item->primary_image }}" 
                                     class="card-img-top" 
                                     alt="{{ $item->name }}"
                                     style="height: 200px; object-fit: cover;">
                            @else
                                <div class="card-img-top bg-light d-flex align-items-center justify-content-center" 
                                     style="height: 200px;">
                                    <i class="bi bi-image text-muted" style="font-size: 3rem;"></i>
                                </div>
                            @endif
                            
                            <!-- Status Badge -->
                            <div class="position-absolute top-0 end-0 m-2">
                                @if($item->is_active)
                                    <span class="badge bg-success">
                                        <i class="bi bi-check-circle me-1"></i>Active
                                    </span>
                                @else
                                    <span class="badge bg-secondary">
                                        <i class="bi bi-pause-circle me-1"></i>Inactive
                                    </span>
                                @endif
                            </div>
                        </div>
                        
                        <div class="card-body d-flex flex-column">
                            <h6 class="card-title mb-2">{{ $item->name }}</h6>
                            
                            <div class="mb-2">
                                <small class="text-muted">
                                    <i class="bi bi-tag me-1"></i>{{ $item->category->name }}
                                </small>
                            </div>
                            
                            <div class="mb-2">
                                <small class="text-muted">
                                    <i class="bi bi-calendar3 me-1"></i>{{ $item->season->name }}
                                </small>
                            </div>
                            
                            @if($item->sku)
                                <div class="mb-2">
                                    <small class="text-muted">
                                        <i class="bi bi-upc me-1"></i>{{ $item->sku }}
                                    </small>
                                </div>
                            @endif
                            
                            <div class="mt-auto">
                                <div class="h5 text-primary mb-3">{{ $item->formatted_price }}</div>
                                
                                <div class="btn-group w-100">
                                    <button class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary btn-sm">
                                        <i class="bi bi-pencil"></i>
                                    </button>
                                    <button class="btn btn-outline-danger btn-sm">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        
        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-4">
            <div class="text-muted small">
                Showing {{ $items->firstItem() }} to {{ $items->lastItem() }} 
                of {{ $items->total() }} items
            </div>
            <div>
                {{ $items->links() }}
            </div>
        </div>
    @else
        <!-- Empty State -->
        <div class="text-center py-5">
            <i class="bi bi-box display-1 text-muted"></i>
            <h4 class="mt-3">No items found</h4>
            <p class="text-muted">
                @if($search || $seasonFilter || $categoryFilter || $statusFilter)
                    No items match your current filters.
                @else
                    Get started by adding your first item.
                @endif
            </p>
            @if($search || $seasonFilter || $categoryFilter || $statusFilter)
                <button wire:click="$set('search', ''); $set('seasonFilter', ''); $set('categoryFilter', ''); $set('statusFilter', '')" 
                        class="btn btn-outline-primary">
                    <i class="bi bi-arrow-clockwise me-2"></i>Clear Filters
                </button>
            @else
                <button class="btn btn-primary">
                    <i class="bi bi-plus-lg me-2"></i>Add Item
                </button>
            @endif
        </div>
    @endif
</div>