<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">Items</h1>
            <p class="text-muted mb-0">Manage your product catalog</p>
        </div>
        <button class="btn btn-primary">
            <i class="bi bi-plus-lg me-2"></i>Add Item
        </button>
    </div>

    <!-- Flash Messages -->
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Search Items</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-search"></i>
                        </span>
                        <input type="text" 
                               wire:model.live.debounce.300ms="search" 
                               class="form-control" 
                               placeholder="Search by name, description, or SKU...">
                    </div>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Season</label>
                    <select wire:model.live="seasonFilter" class="form-select">
                        <option value="">All Seasons</option>
                        @foreach($seasons as $season)
                            <option value="{{ $season->id }}">{{ $season->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Category</label>
                    <select wire:model.live="categoryFilter" class="form-select">
                        <option value="">All Categories</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select wire:model.live="statusFilter" class="form-select">
                        <option value="">All Statuses</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label class="form-label">Per Page</label>
                    <select wire:model.live="perPage" class="form-select">
                        <option value="12">12</option>
                        <option value="24">24</option>
                        <option value="48">48</option>
                    </select>
                </div>
                
                <div class="col-md-1 d-flex align-items-end">
                    @if($search || $seasonFilter || $categoryFilter || $statusFilter)
                        <button wire:click="$set('search', ''); $set('seasonFilter', ''); $set('categoryFilter', ''); $set('statusFilter', '')" 
                                class="btn btn-outline-secondary">
                            <i class="bi bi-x-lg"></i>
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Items Table -->
    <div class="card">
        <div class="card-body p-0">
            @if($items->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0">Item</th>
                                <th class="border-0">Category</th>
                                <th class="border-0">Season</th>
                                <th class="border-0">SKU</th>
                                <th class="border-0">Price</th>
                                <th class="border-0">Status</th>
                                <th class="border-0 text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($items as $item)
                                <tr class="cursor-pointer" onclick="window.location.href='{{ route('admin.items.show', $item->id) }}'">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="me-3">
                                                @if($item->primary_image)
                                                    <img src="{{ $item->primary_image }}" 
                                                         alt="{{ $item->name }}"
                                                         class="rounded"
                                                         style="width: 50px; height: 50px; object-fit: cover;">
                                                @else
                                                    <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                                         style="width: 50px; height: 50px;">
                                                        <i class="bi bi-image text-muted"></i>
                                                    </div>
                                                @endif
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $item->name }}</div>
                                                @if($item->short_description)
                                                    <div class="small text-muted">{{ Str::limit($item->short_description, 50) }}</div>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ $item->category->name }}</span>
                                    </td>
                                    <td>
                                        <span class="badge bg-info">{{ $item->season->name }}</span>
                                    </td>
                                    <td>
                                        @if($item->sku)
                                            <code class="small">{{ $item->sku }}</code>
                                        @else
                                            <span class="text-muted small">No SKU</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="fw-semibold text-primary">{{ $item->formatted_price }}</div>
                                    </td>
                                    <td>
                                        @if($item->is_active)
                                            <span class="badge bg-success">
                                                <i class="bi bi-check-circle me-1"></i>Active
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="bi bi-pause-circle me-1"></i>Inactive
                                            </span>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm" onclick="event.stopPropagation()">
                                            <a href="{{ route('admin.items.show', $item->id) }}" 
                                               class="btn btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <button class="btn btn-outline-secondary">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center p-3 border-top">
                    <div class="text-muted small">
                        Showing {{ $items->firstItem() }} to {{ $items->lastItem() }} 
                        of {{ $items->total() }} items
                    </div>
                    <div>
                        {{ $items->links() }}
                    </div>
                </div>
    @else
        <!-- Empty State -->
        <div class="text-center py-5">
            <i class="bi bi-box display-1 text-muted"></i>
            <h4 class="mt-3">No items found</h4>
            <p class="text-muted">
                @if($search || $seasonFilter || $categoryFilter || $statusFilter)
                    No items match your current filters.
                @else
                    Get started by adding your first item.
                @endif
            </p>
            @if($search || $seasonFilter || $categoryFilter || $statusFilter)
                <button wire:click="$set('search', ''); $set('seasonFilter', ''); $set('categoryFilter', ''); $set('statusFilter', '')" 
                        class="btn btn-outline-primary">
                    <i class="bi bi-arrow-clockwise me-2"></i>Clear Filters
                </button>
            @else
                <button class="btn btn-primary">
                    <i class="bi bi-plus-lg me-2"></i>Add Item
                </button>
            @endif
        </div>
    @endif
</div>