<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\AuthController;
use App\Http\Controllers\Api\V1\LibraryController;
use App\Http\Controllers\Api\V1\CustomSessionController;
use App\Http\Controllers\Api\V1\ProfileController;
use App\Http\Controllers\Api\V1\AdminController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::prefix('v1')->group(function () {
    // Public routes
    Route::post('/auth/login', [AuthController::class, 'login']);
    Route::post('/auth/register', [AuthController::class, 'register']);
    Route::post('/auth/logout', [AuthController::class, 'logout'])->middleware('auth:sanctum');
    
    // Library routes (public)
    Route::get('/library', [LibraryController::class, 'index']);
    Route::get('/library/categories', [LibraryController::class, 'categories']);
    Route::get('/library/tracks', [LibraryController::class, 'tracks']);
    Route::get('/library/tracks/{track}', [LibraryController::class, 'show']);
    Route::get('/library/search', [LibraryController::class, 'search']);
    
    // Protected routes
    Route::middleware('auth:sanctum')->group(function () {
        // Profile
        Route::get('/profile', [ProfileController::class, 'show']);
        Route::put('/profile', [ProfileController::class, 'update']);
        Route::get('/profile/consents', [ProfileController::class, 'consents']);
        Route::put('/profile/consents', [ProfileController::class, 'updateConsents']);
        
        // Custom sessions
        Route::post('/custom/sessions', [CustomSessionController::class, 'store']);
        Route::get('/custom/sessions', [CustomSessionController::class, 'index']);
        Route::get('/custom/sessions/{session}', [CustomSessionController::class, 'show']);
        
        // Admin routes
        Route::middleware('admin')->group(function () {
            Route::get('/admin/categories', [AdminController::class, 'categories']);
            Route::post('/admin/categories', [AdminController::class, 'storeCategory']);
            Route::put('/admin/categories/{category}', [AdminController::class, 'updateCategory']);
            Route::delete('/admin/categories/{category}', [AdminController::class, 'destroyCategory']);
            
            Route::get('/admin/tracks', [AdminController::class, 'tracks']);
            Route::post('/admin/tracks', [AdminController::class, 'storeTrack']);
            Route::put('/admin/tracks/{track}', [AdminController::class, 'updateTrack']);
            Route::delete('/admin/tracks/{track}', [AdminController::class, 'destroyTrack']);
            
            Route::get('/admin/safety-events', [AdminController::class, 'safetyEvents']);
        });
    });
});
