<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('category_id')->constrained()->cascadeOnDelete();
            $table->foreignId('season_id')->nullable()->constrained()->restrictOnDelete();
            $table->string('name', 200);
            $table->string('slug', 200)->unique();
            $table->string('sku', 80)->unique();
            $table->text('description')->nullable();
            $table->smallInteger('colour_grid_columns')->default(3);
            $table->boolean('has_colourways')->default(true);
            $table->jsonb('attributes')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Indexes
            $table->index('category_id');
            $table->index('season_id');
            $table->index('is_active');
        });

        // PostgreSQL CHECK constraints
        DB::statement("ALTER TABLE items ADD CONSTRAINT check_colour_grid_columns CHECK (colour_grid_columns BETWEEN 1 AND 8)");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('items');
    }
};
