<div class="max-w-3xl">
    @if (session('status'))
        <div class="mb-4 p-3 rounded border border-green-200 text-green-800 bg-green-50">
            {{ session('status') }}
        </div>
    @endif

    <form wire:submit.prevent="submit" class="space-y-4">
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Month</label>
                <input type="number" min="1" max="12" wire:model.defer="month" class="mt-1 w-full rounded-md border-gray-300 dark:border-gray-700 dark:bg-gray-900" placeholder="1-12" />
                @error('month') <div class="text-sm text-red-600 mt-1">{{ $message }}</div> @enderror
            </div>
            <div>
                <label class="block text-sm font-medium">Year</label>
                <input type="number" min="2000" max="2100" wire:model.defer="year" class="mt-1 w-full rounded-md border-gray-300 dark:border-gray-700 dark:bg-gray-900" placeholder="YYYY" />
                @error('year') <div class="text-sm text-red-600 mt-1">{{ $message }}</div> @enderror
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium">Cardholder Name</label>
                <input type="text" wire:model.defer="cardholder_name" class="mt-1 w-full rounded-md border-gray-300 dark:border-gray-700 dark:bg-gray-900" />
                @error('cardholder_name') <div class="text-sm text-red-600 mt-1">{{ $message }}</div> @enderror
            </div>
            <div>
                <label class="block text-sm font-medium">Account Number (masked)</label>
                <input type="text" wire:model.defer="account_number_masked" class="mt-1 w-full rounded-md border-gray-300 dark:border-gray-700 dark:bg-gray-900" placeholder="****1234" />
                @error('account_number_masked') <div class="text-sm text-red-600 mt-1">{{ $message }}</div> @enderror
            </div>
        </div>

        <div>
            <label class="block text-sm font-medium">Statement File</label>
            <input type="file" wire:model="file" class="mt-1 w-full text-sm" />
            @error('file') <div class="text-sm text-red-600 mt-1">{{ $message }}</div> @enderror

            <div wire:loading wire:target="file" class="text-sm text-gray-500 mt-1">Uploading...</div>
        </div>

        <div>
            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500">Import</button>
        </div>
    </form>
</div>


