<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Statement extends Model
{
    use HasFactory;

    protected $fillable = [
        'cardholder_name',
        'account_number_last4',
        'start_date',
        'end_date',
        'statement_cycle',
        'status',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
    ];

    public function transactions(): HasMany
    {
        return $this->hasMany(StatementTransaction::class);
    }
}


