<?php

namespace App\Models;

use \Bkwld\Cloner\Cloneable;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

/**
 * Accessory model
 * 
 * Represents accessories used in the system.
 * 
 * @deprecated This class will be removed after upgrade
 */
class Accessories extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory;
    use Cloneable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'suppliers_id',
        'code',
        'accessory',
        'type',
    ];

    /**
     * Get the type attribute with proper formatting.
     * 
     * @return \Illuminate\Database\Eloquent\Casts\Attribute
     */
    protected function Type(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => ucwords($value),
            set: fn ($value) => strtolower($value),
        );
    }

    /**
     * Get the supplier for this accessory.
     * 
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function suppliers()
    {
        return $this->belongsTo(Suppliers::class);
    }

    /**
     * Get the colourway accessories for this accessory.
     * 
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function colourway_accessories()
    {
        return $this->hasMany(ColourwayAccessories::class);
    }

    /**
     * Get the accessory colours for this accessory.
     * 
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function accessory_colours()
    {
        return $this->hasMany(AccessoryColours::class);
    }
}