@extends('layouts.frontend')

@section('meta_title', $product->meta_title ?? $product->name . ' - Yarn Store')
@section('meta_description', $product->meta_description ?? $product->short_description ?? Str::limit($product->description, 160))

@push('head')
@php
$__productLd = [
    '@context' => 'https://schema.org',
    '@type' => 'Product',
    'name' => $product->name,
    'description' => $product->description,
    'sku' => $product->sku,
    'brand' => [
        '@type' => 'Brand',
        'name' => 'Robert Todd Yarn'
    ],
    'offers' => [
        '@type' => 'Offer',
        'price' => $product->price,
        'priceCurrency' => 'GBP',
        'availability' => 'https://schema.org/InStock'
    ]
];
@endphp
<script type="application/ld+json">
{!! json_encode($__productLd, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
</script>
@endpush

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <a href="{{ route('collections') }}">Collections</a>
                <span>/</span>
                <a href="{{ route('collections.season', $product->season->slug) }}">{{ $product->season->name }}</a>
                <span>/</span>
                <a href="{{ route('category', $product->category->slug) }}">{{ $product->category->name }}</a>
                <span>/</span>
                <span>{{ $product->name }}</span>
            </nav>
        </div>
    </div>

    <div class="row g-5 mt-2">
        <!-- Product Images -->
        <div class="col-lg-6">
            <div class="ys-card overflow-hidden">
                @if($product->images && count($product->images) > 0)
                    <img src="{{ Storage::url($product->images[0]) }}" 
                         alt="{{ $product->name }}" 
                         class="w-100"
                         style="aspect-ratio: 1; object-fit: cover;"
                         loading="lazy">
                @else
                    <div class="w-100 d-flex align-items-center justify-content-center" 
                         style="aspect-ratio: 1; background-color: var(--ys-bg-tertiary);">
                        <span class="text-muted">No image available</span>
                    </div>
                @endif
            </div>

            @if($product->images && count($product->images) > 1)
                <div class="row g-2 mt-2">
                    @foreach(array_slice($product->images, 1, 4) as $image)
                        <div class="col-3">
                            <img src="{{ Storage::url($image) }}" 
                                 alt="{{ $product->name }}" 
                                 class="w-100 rounded"
                                 style="aspect-ratio: 1; object-fit: cover; cursor: pointer;"
                                 loading="lazy">
                        </div>
                    @endforeach
                </div>
            @endif
        </div>

        <!-- Product Details -->
        <div class="col-lg-6">
            <div class="mb-2">
                <span class="badge" style="background-color: var(--ys-primary);">{{ $product->season->name }}</span>
                <span class="badge" style="background-color: var(--ys-secondary);">{{ $product->category->name }}</span>
            </div>

            <h1 class="display-5 fw-bold mb-3">{{ $product->name }}</h1>

            @if($product->short_description)
                <p class="lead text-muted mb-4">{{ $product->short_description }}</p>
            @endif

            <div class="mb-4">
                <span class="h2 fw-bold" style="color: var(--ys-primary);">{{ $product->formatted_price }}</span>
                <span class="text-muted ms-2">Inc. VAT</span>
            </div>

            @if($product->sku)
                <p class="text-muted mb-4">SKU: {{ $product->sku }}</p>
            @endif

            @livewire('add-to-basket', ['itemId' => $product->id, 'colourways' => $product->colourways])

            <hr class="my-5">

            @if($product->description)
                <div class="mb-4">
                    <h2 class="h5 fw-bold mb-3">Description</h2>
                    <div class="text-muted">
                        {!! nl2br(e($product->description)) !!}
                    </div>
                </div>
            @endif

            @if($product->specifications && count($product->specifications) > 0)
                <div class="mb-4">
                    <h2 class="h5 fw-bold mb-3">Specifications</h2>
                    <table class="table table-sm">
                        <tbody>
                            @foreach($product->specifications as $key => $value)
                                <tr>
                                    <th style="width: 40%;">{{ ucfirst($key) }}</th>
                                    <td>{{ $value }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>

    <!-- Colourways Section -->
    @if($product->colourways->count() > 0)
        <div class="row mt-5">
            <div class="col-12">
                <h2 class="h3 fw-bold mb-4">Available Colourways</h2>
            </div>
            <div class="col-12">
                <div class="row g-4">
                    @foreach($product->colourways as $colourway)
                        <div class="col-lg-3 col-md-4 col-sm-6">
                            <div class="ys-card p-3 text-center">
                                @if($colourway->image)
                                    <img src="{{ Storage::url($colourway->image) }}" 
                                         alt="{{ $colourway->reference }}" 
                                         class="w-100 rounded mb-3"
                                         style="aspect-ratio: 1; object-fit: cover;"
                                         loading="lazy">
                                @else
                                    <div class="w-100 rounded mb-3 d-flex align-items-center justify-content-center" 
                                         style="aspect-ratio: 1; background-color: var(--ys-bg-tertiary);">
                                        <span class="text-muted small">No image</span>
                                    </div>
                                @endif
                                <p class="fw-semibold mb-0">{{ $colourway->reference }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif

    <!-- Related Products -->
    @if($relatedProducts->count() > 0)
        <div class="row mt-5">
            <div class="col-12">
                <h2 class="h3 fw-bold mb-4">You May Also Like</h2>
            </div>
            <div class="col-12">
                <div class="product-grid">
                    @foreach($relatedProducts as $relatedProduct)
                        <a href="{{ route('product', $relatedProduct->slug) }}" class="text-decoration-none">
                            <div class="product-card">
                                @if($relatedProduct->primary_image)
                                    <img src="{{ Storage::url($relatedProduct->primary_image) }}" 
                                         alt="{{ $relatedProduct->name }}" 
                                         class="product-image"
                                         loading="lazy">
                                @else
                                    <div class="product-image d-flex align-items-center justify-content-center" 
                                         style="background-color: var(--ys-bg-tertiary);">
                                        <span class="text-muted">No image</span>
                                    </div>
                                @endif
                                <div class="product-info">
                                    <h3 class="h6 fw-bold mb-2" style="color: var(--ys-text-primary);">
                                        {{ $relatedProduct->name }}
                                    </h3>
                                    <p class="text-muted small mb-2">
                                        {{ $relatedProduct->season->name }}
                                    </p>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold" style="color: var(--ys-primary);">
                                            {{ $relatedProduct->formatted_price }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
</div>
@endsection

