@extends('layouts.shop')

@section('title', 'GDPR Information - Yarn Store')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">GDPR & Data Protection</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="ys-card p-4">
                <p class="lead mb-4">Robert Todd Yarn Ltd is committed to protecting your personal data in accordance with UK GDPR and the Data Protection Act 2018.</p>

                <h3 class="fw-bold mb-3">Your Rights Under GDPR</h3>
                <p>You have the following rights regarding your personal data:</p>

                <div class="mb-4">
                    <h5 class="fw-bold">1. Right to Access</h5>
                    <p>You can request a copy of all personal data we hold about you.</p>
                </div>

                <div class="mb-4">
                    <h5 class="fw-bold">2. Right to Rectification</h5>
                    <p>You can request correction of inaccurate or incomplete data.</p>
                </div>

                <div class="mb-4">
                    <h5 class="fw-bold">3. Right to Erasure ("Right to be Forgotten")</h5>
                    <p>You can request deletion of your personal data, subject to legal obligations.</p>
                </div>

                <div class="mb-4">
                    <h5 class="fw-bold">4. Right to Restrict Processing</h5>
                    <p>You can request limitation of how we use your data.</p>
                </div>

                <div class="mb-4">
                    <h5 class="fw-bold">5. Right to Data Portability</h5>
                    <p>You can receive your data in a structured, machine-readable format.</p>
                </div>

                <div class="mb-4">
                    <h5 class="fw-bold">6. Right to Object</h5>
                    <p>You can object to processing based on legitimate interests or for marketing.</p>
                </div>

                <div class="mb-4">
                    <h5 class="fw-bold">7. Rights Related to Automated Decision-Making</h5>
                    <p>You have rights regarding automated decisions that significantly affect you.</p>
                </div>

                <h3 class="fw-bold mb-3 mt-5">How to Exercise Your Rights</h3>
                <p>To exercise any of these rights, please contact us:</p>
                <ul>
                    <li><strong>Email:</strong> privacy@yarnstore.co.uk</li>
                    <li><strong>Phone:</strong> 01234 567890</li>
                    <li><strong>Post:</strong> Data Protection Officer, Robert Todd Yarn Ltd, [Address]</li>
                </ul>
                <p>We will respond to your request within one month.</p>

                <h3 class="fw-bold mb-3 mt-5">Data Protection Officer</h3>
                <p>If you have concerns about how we handle your data, you can contact our Data Protection Officer at dpo@yarnstore.co.uk</p>

                <h3 class="fw-bold mb-3 mt-5">Complaints</h3>
                <p>If you're not satisfied with our response, you have the right to lodge a complaint with the Information Commissioner's Office (ICO):</p>
                <ul>
                    <li><strong>Website:</strong> ico.org.uk</li>
                    <li><strong>Phone:</strong> 0303 123 1113</li>
                </ul>

                <h3 class="fw-bold mb-3 mt-5">Data Breach Notification</h3>
                <p>In the event of a data breach that affects your rights, we will notify you and the ICO within 72 hours as required by law.</p>
            </div>
        </div>
    </div>
</div>
@endsection








