<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('receipts', function (Blueprint $table) {
            $table->id();
            $table->timestamp('uploaded_at')->nullable();
            $table->date('purchase_date')->nullable();
            $table->string('merchant_name')->nullable();
            $table->decimal('total_amount', 12, 2)->nullable();
            $table->string('currency', 3)->nullable();
            $table->string('source')->nullable();
            $table->string('image_path')->nullable();
            $table->enum('status', ['new', 'matched', 'reviewed'])->default('new');
            $table->boolean('is_personal')->default(false);
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index(['purchase_date']);
            $table->index(['merchant_name']);
            $table->index(['total_amount', 'currency']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receipts');
    }
};
