<?php

namespace App\Http\Controllers;

use App\Models\Season;
use App\Models\Category;
use App\Models\Item;
use Illuminate\Http\Response;

class SitemapController extends Controller
{
    public function index()
    {
        $sitemap = '<?xml version="1.0" encoding="UTF-8"?>';
        $sitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

        // Homepage
        $sitemap .= $this->addUrl(route('home'), now(), 'daily', '1.0');

        // Collections page
        $sitemap .= $this->addUrl(route('collections'), now(), 'weekly', '0.9');

        // Seasons
        $seasons = Season::where('is_active', true)->get();
        foreach ($seasons as $season) {
            $sitemap .= $this->addUrl(
                route('collections.season', $season->slug),
                $season->updated_at,
                'weekly',
                '0.8'
            );
        }

        // Categories
        $categories = Category::where('is_active', true)->get();
        foreach ($categories as $category) {
            $sitemap .= $this->addUrl(
                route('category', $category->slug),
                $category->updated_at,
                'weekly',
                '0.8'
            );
        }

        // Products
        $products = Item::where('is_active', true)->get();
        foreach ($products as $product) {
            $sitemap .= $this->addUrl(
                route('product', $product->slug),
                $product->updated_at,
                'monthly',
                '0.7'
            );
        }

        // Static pages
        $staticPages = [
            ['url' => route('about'), 'priority' => '0.6'],
            ['url' => route('care-guide'), 'priority' => '0.6'],
            ['url' => route('patterns'), 'priority' => '0.6'],
            ['url' => route('contact'), 'priority' => '0.5'],
            ['url' => route('terms'), 'priority' => '0.3'],
            ['url' => route('privacy'), 'priority' => '0.3'],
            ['url' => route('cookies'), 'priority' => '0.3'],
        ];

        foreach ($staticPages as $page) {
            $sitemap .= $this->addUrl($page['url'], now(), 'monthly', $page['priority']);
        }

        $sitemap .= '</urlset>';

        return response($sitemap, 200)
            ->header('Content-Type', 'application/xml');
    }

    private function addUrl($loc, $lastmod, $changefreq, $priority)
    {
        $url = '<url>';
        $url .= '<loc>' . htmlspecialchars($loc) . '</loc>';
        $url .= '<lastmod>' . $lastmod->format('Y-m-d') . '</lastmod>';
        $url .= '<changefreq>' . $changefreq . '</changefreq>';
        $url .= '<priority>' . $priority . '</priority>';
        $url .= '</url>';
        
        return $url;
    }
}
