<?php

namespace App\Livewire\Finance;

use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Validation\Rule;
use App\Services\StatementImportService;
use Illuminate\Support\Facades\Storage;

class StatementImport extends Component
{
    use WithFileUploads;

    public $file;
    public $cardholder_name;
    public $account_number_masked;
    public $period_start;
    public $period_end;

    protected function rules(): array
    {
        return [
            'file' => ['required', 'file', 'mimes:xlsx,xls,csv'],
            'cardholder_name' => ['required', 'string', 'max:255'],
            'account_number_masked' => ['required', 'string', 'max:32'],
            'period_start' => ['required', 'date'],
            'period_end' => ['required', 'date', 'after_or_equal:period_start'],
        ];
    }

    public function import(StatementImportService $service)
    {
        $this->validate();

        $path = $this->file->store('statements', 'local');

        $result = $service->import(
            path: Storage::disk('local')->path($path),
            cardholderName: $this->cardholder_name,
            accountNumberMasked: $this->account_number_masked,
            periodStart: $this->period_start,
            periodEnd: $this->period_end,
            originalFilename: $this->file->getClientOriginalName(),
            storagePath: $path,
        );

        session()->flash('status', "Imported {$result['transactions_imported']} transactions into statement #{$result['statement_id']}");
        $this->reset(['file']);
    }
    public function render()
    {
        return view('livewire.finance.statement-import');
    }
}
