<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('library_tracks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained('library_categories')->onDelete('cascade');
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->text('transcript')->nullable();
            $table->string('audio_path');
            $table->string('image_path')->nullable();
            $table->integer('duration_seconds')->default(0);
            $table->json('tags')->nullable();
            $table->string('voice_type')->default('female');
            $table->string('difficulty_level')->default('beginner');
            $table->boolean('is_active')->default(true);
            $table->integer('play_count')->default(0);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('library_tracks');
    }
};
