<x-app-layout>
    <!-- Hero Section -->
    <section class="collection-hero position-relative overflow-hidden bg-dark text-white py-5">
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center py-5">
                <div class="col-lg-8">
                    <div class="collection-hero-content" data-aos="fade-up">
                        <nav aria-label="breadcrumb" class="mb-4">
                            <ol class="breadcrumb breadcrumb-dark">
                                <li class="breadcrumb-item"><a href="{{ route('collections') }}" class="text-light text-decoration-none">Collections</a></li>
                                <li class="breadcrumb-item active" aria-current="page">{{ $season->code }}</li>
                            </ol>
                        </nav>
                        
                        <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                            <i class="bi bi-{{ $season->half === 'AW' ? 'snow' : 'sun' }} me-2"></i>{{ $season->label }}
                        </span>
                        
                        <h1 class="display-3 fw-light mb-4 text-white">
                            {{ $season->code }} Collection
                            <span class="d-block fw-normal fs-2 mt-2 text-light">{{ $season->label }}</span>
                        </h1>
                        
                        <p class="lead mb-4 text-light opacity-90">
                            {{ $season->description }}
                        </p>
                        
                        @if($season->starts_on && $season->ends_on)
                            <div class="collection-meta mb-4">
                                <p class="text-light opacity-90 mb-2">
                                    <i class="bi bi-calendar-event me-2"></i>
                                    Available: {{ \Carbon\Carbon::parse($season->starts_on)->format('M Y') }} - {{ \Carbon\Carbon::parse($season->ends_on)->format('M Y') }}
                                </p>
                            </div>
                        @endif
                        
                        <div class="collection-stats d-flex gap-4 mb-4">
                            <div class="stat-item text-center">
                                <div class="stat-number text-primary fw-bold fs-3">{{ $items->count() }}</div>
                                <div class="stat-label text-light opacity-75 small">Items</div>
                            </div>
                            <div class="stat-item text-center">
                                <div class="stat-number text-primary fw-bold fs-3">{{ $categories->count() }}</div>
                                <div class="stat-label text-light opacity-75 small">Categories</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="collection-hero-image text-center" data-aos="fade-left">
                        <div class="season-icon-large mb-4">
                            <i class="bi bi-{{ $season->half === 'AW' ? 'snow' : 'sun' }} display-1 text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="collection-hero-pattern"></div>
    </section>

    <!-- Categories Overview -->
    @if($categories->count() > 0)
        <section class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Categories in {{ $season->code }}</h2>
                    <p class="text-muted lead">Browse items by category within this collection</p>
                </div>
                
                <div class="row g-4">
                    @foreach($categories as $index => $category)
                        <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="category-overview-card h-100 p-4 rounded shadow-sm border-0">
                                <div class="category-icon mb-3">
                                    <i class="bi bi-palette2 display-4 text-primary"></i>
                                </div>
                                <h5 class="fw-semibold mb-3">{{ $category->name }}</h5>
                                @if($category->description)
                                    <p class="text-muted mb-3">{{ $category->description }}</p>
                                @endif
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="badge bg-primary-subtle text-primary">{{ $category->items_count }} items</span>
                                    <a href="#category-{{ $category->id }}" class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-arrow-down me-1"></i>View Items
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Items by Category -->
    @if($categories->count() > 0)
        <section class="py-5 bg-light">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Collection Items</h2>
                    <p class="text-muted lead">Explore all items in the {{ $season->code }} collection</p>
                </div>
                
                @foreach($categories as $category)
                    <div id="category-{{ $category->id }}" class="category-section mb-5">
                        <div class="row align-items-center mb-4">
                            <div class="col-md-6">
                                <h3 class="fw-semibold mb-2">{{ $category->name }}</h3>
                                <p class="text-muted mb-0">{{ $category->items_count }} items available</p>
                            </div>
                            <div class="col-md-6 text-md-end">
                                <a href="#" class="btn btn-outline-primary">View All {{ $category->name }}</a>
                            </div>
                        </div>
                        
                        <div class="row g-4">
                            @foreach($items->where('category_id', $category->id) as $item)
                                <div class="col-md-6 col-lg-4" data-aos="fade-up">
                                    <div class="collection-item-card h-100 rounded shadow-sm border-0 overflow-hidden">
                                        <div class="item-image position-relative">
                                            <div class="ratio ratio-4x3">
                                                <img src="https://as2.ftcdn.net/v2/jpg/03/65/51/06/1000_F_365510635_E8b3EsXrTq7F4QyYxw0qBz1lWY0eH6gS.jpg" 
                                                     class="w-100 h-100 object-fit-cover" alt="{{ $item->name }}">
                                            </div>
                                            <div class="item-overlay">
                                                <div class="item-overlay-content text-center text-white">
                                                    <h6 class="fw-semibold mb-2">{{ $item->name }}</h6>
                                                    <p class="small opacity-90">{{ $item->category->name }}</p>
                                                    <span class="badge bg-primary">View Details</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="item-content p-4">
                                            <h6 class="fw-semibold mb-2">{{ $item->name }}</h6>
                                            <p class="text-muted small mb-2">{{ $item->category->name }}</p>
                                            @if($item->description)
                                                <p class="text-muted small mb-3">{{ Str::limit($item->description, 80) }}</p>
                                            @endif
                                            @if($item->colourways->count() > 0)
                                                <div class="colourway-preview mb-3">
                                                    <small class="text-muted d-block mb-2">Available in {{ $item->colourways->count() }} colours</small>
                                                    <div class="d-flex gap-2 flex-wrap">
                                                        @foreach($item->colourways->take(4) as $colourway)
                                                            <div class="colourway-dot" 
                                                                 style="background-color: {{ $colourway->colour_code }}; width: 20px; height: 20px; border-radius: 50%; border: 2px solid white; box-shadow: 0 2px 4px rgba(0,0,0,0.1);"
                                                                 title="{{ $colourway->name }}"></div>
                                                        @endforeach
                                                        @if($item->colourways->count() > 4)
                                                            <span class="text-muted small">+{{ $item->colourways->count() - 4 }} more</span>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endif
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="text-primary fw-semibold">View Details</span>
                                                <a href="#" class="btn btn-outline-primary btn-sm">
                                                    <i class="bi bi-arrow-right"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </section>
    @endif

    <!-- Related Seasons -->
    @if($relatedSeasons->count() > 0)
        <section class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Explore Other Collections</h2>
                    <p class="text-muted lead">Discover more seasonal collections</p>
                </div>
                
                <div class="row g-4">
                    @foreach($relatedSeasons as $relatedSeason)
                        <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ $loop->index * 100 }}">
                            <div class="related-season-card h-100 p-4 rounded shadow-sm border-0 text-center">
                                <div class="season-icon mb-3">
                                    <i class="bi bi-{{ $relatedSeason->half === 'AW' ? 'snow' : 'sun' }} display-4 text-primary"></i>
                                </div>
                                <h5 class="fw-semibold mb-3">{{ $relatedSeason->code }}</h5>
                                <p class="text-muted mb-3">{{ $relatedSeason->label }}</p>
                                <a href="{{ route('collection.detail', $relatedSeason->code) }}" class="btn btn-primary">
                                    <i class="bi bi-arrow-right me-2"></i>Explore {{ $relatedSeason->code }}
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Call to Action -->
    <section class="py-5 bg-primary text-white">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <h2 class="fw-light display-6 mb-4">Need Help Choosing?</h2>
                    <p class="lead mb-4 opacity-90">
                        Our textile specialists can guide you to the perfect yarn for your {{ $season->code }} project.
                    </p>
                    <div class="d-flex gap-3 justify-content-center flex-wrap">
                        <a href="#newsletter" class="btn btn-light btn-lg px-4">
                            <i class="bi bi-envelope me-2"></i>Get Updates
                        </a>
                        <a href="#" class="btn btn-outline-light btn-lg px-4">
                            <i class="bi bi-chat-dots me-2"></i>Contact Us
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new collections, exclusive releases, and expert knitting insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
