<x-app-layout>
    <!-- Hero Section -->
    <section class="collection-hero position-relative overflow-hidden bg-dark text-white py-5">
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center py-5">
                <div class="col-lg-8">
                    <div class="collection-hero-content" data-aos="fade-up">
                        <nav aria-label="breadcrumb" class="mb-4">
                            <ol class="breadcrumb breadcrumb-dark">
                                <li class="breadcrumb-item"><a href="/" class="text-light text-decoration-none">Home</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('collections') }}" class="text-light text-decoration-none">Collections</a></li>
                                <li class="breadcrumb-item active" aria-current="page">{{ $season->code }}</li>
                            </ol>
                        </nav>
                        
                        <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                            <i class="bi bi-{{ $season->half === 'AW' ? 'snow' : 'sun' }} me-2"></i>{{ $season->label }}
                        </span>
                        
                        <h1 class="display-3 fw-light mb-4 text-white">
                            {{ $season->code }} Collection
                            <span class="d-block fw-normal fs-2 mt-2 text-light">{{ $season->label }}</span>
                        </h1>
                        
                        <p class="lead mb-4 text-light opacity-90">
                            {{ $season->description }}
                        </p>
                        
                        @if($season->starts_on && $season->ends_on)
                            <div class="collection-meta mb-4">
                                <p class="text-light opacity-90 mb-2">
                                    <i class="bi bi-calendar-event me-2"></i>
                                    Available: {{ \Carbon\Carbon::parse($season->starts_on)->format('M Y') }} - {{ \Carbon\Carbon::parse($season->ends_on)->format('M Y') }}
                                </p>
                            </div>
                        @endif
                        
                        <div class="collection-stats d-flex gap-4 mb-4">
                            <div class="stat-item text-center">
                                <div class="stat-number text-primary fw-bold fs-3">{{ $items->count() }}</div>
                                <div class="stat-label text-light opacity-75 small">Items</div>
                            </div>
                            <div class="stat-item text-center">
                                <div class="stat-number text-primary fw-bold fs-3">{{ $categories->count() }}</div>
                                <div class="stat-label text-light opacity-75 small">Categories</div>
                            </div>
                        </div>
                        
                        <div class="d-flex gap-3 flex-wrap">
                            <a href="{{ route('collections') }}" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-arrow-left me-2"></i>Back to Collections
                            </a>
                            <a href="#categories" class="btn btn-primary btn-lg px-4 py-3">
                                <i class="bi bi-arrow-down me-2"></i>Browse Yarns
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="collection-hero-image text-center" data-aos="fade-left">
                        @if($season->image_path)
                            <div class="season-image-large mb-4">
                                <img src="{{ $season->image_path }}" class="img-fluid rounded shadow" alt="{{ $season->code }} Collection">
                            </div>
                        @else
                            <div class="season-icon-large mb-4">
                                <i class="bi bi-{{ $season->half === 'AW' ? 'snow' : 'sun' }} display-1 text-primary"></i>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="collection-hero-pattern"></div>
    </section>

    <!-- Yarns by Category -->
    @if($categories->count() > 0)
        <section id="categories" class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">{{ $season->code }} Yarns by Category</h2>
                    <p class="text-muted lead">Browse our yarns organized by fibre type and application</p>
                </div>
                
                @foreach($categories as $categoryIndex => $category)
                    @if($category->items_count > 0)
                        <div class="category-section mb-5" data-aos="fade-up" data-aos-delay="{{ ($categoryIndex + 1) * 100 }}">
                            <div class="category-header mb-4">
                                <div class="row align-items-center">
                                    <div class="col-lg-8">
                                        <h3 class="fw-light display-6 mb-3">{{ $category->name }}</h3>
                                        @if($category->description)
                                            <p class="text-muted lead mb-3">{{ $category->description }}</p>
                                        @endif
                                        <div class="d-flex gap-3 align-items-center">
                                            <span class="badge bg-primary px-3 py-2">{{ $category->items_count }} {{ Str::plural('item', $category->items_count) }}</span>
                                            @if($category->sort_order > 0)
                                                <span class="badge bg-secondary-subtle text-secondary px-3 py-2">Priority {{ $category->sort_order }}</span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-4 text-center">
                                        <div class="category-icon-large">
                                            <i class="bi bi-palette2 display-1 text-primary"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row g-4">
                                @foreach($items->where('category_id', $category->id) as $itemIndex => $item)
                                    <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ ($itemIndex + 1) * 100 }}">
                                        <div class="category-item-card h-100 rounded shadow-sm border-0 overflow-hidden bg-white">
                                            <div class="item-image position-relative">
                                                <div class="ratio ratio-4x3">
                                                    @if($item->season && $item->season->image_path)
                                                        <img src="{{ $item->season->image_path }}" class="w-100 h-100 object-fit-cover" alt="{{ $item->name }}">
                                                    @else
                                                        <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                                                            <i class="bi bi-{{ $item->season && $item->season->half === 'AW' ? 'snow' : 'sun' }} display-4 text-muted"></i>
                                                        </div>
                                                    @endif
                                                </div>
                                                @if($item->season)
                                                    <div class="item-season-badge">
                                                        <span class="badge bg-primary">{{ $item->season->code }}</span>
                                                    </div>
                                                @endif
                                            </div>
                                            
                                            <div class="item-content p-4">
                                                <h6 class="fw-semibold mb-2">{{ $item->name }}</h6>
                                                <p class="text-muted small mb-2">{{ $item->category->name }}</p>
                                                
                                                @if($item->description)
                                                    <p class="text-muted small mb-3">{{ Str::limit($item->description, 80) }}</p>
                                                @endif
                                                
                                                @if($item->attributes)
                                                    <div class="item-attributes mb-3">
                                                        @foreach($item->attributes as $key => $value)
                                                            @if(in_array($key, ['weight', 'gauge', 'type']))
                                                                <span class="badge bg-light text-dark me-1 mb-1">
                                                                    {{ ucfirst($key) }}: {{ $value }}
                                                                </span>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                @endif
                                                
                                                @if($item->colourways && $item->colourways->count() > 0)
                                                    <div class="colourway-preview mb-3">
                                                        <small class="text-muted d-block mb-2">{{ $item->colourways->count() }} {{ Str::plural('colourway', $item->colourways->count()) }} available</small>
                                                        <div class="d-flex gap-1">
                                                            @foreach($item->colourways->take(5) as $colourway)
                                                                <div class="colourway-dot" title="{{ $colourway->name }}"></div>
                                                            @endforeach
                                                            @if($item->colourways->count() > 5)
                                                                <small class="text-muted ms-2">+{{ $item->colourways->count() - 5 }} more</small>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endif
                                                
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <span class="text-primary fw-semibold small">{{ $item->sku }}</span>
                                                    <a href="#" class="btn btn-outline-primary btn-sm">
                                                        <i class="bi bi-arrow-right"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </section>
    @else
        <section id="categories" class="py-5 bg-white">
            <div class="container">
                <div class="text-center" data-aos="fade-up">
                    <div class="empty-state mb-4">
                        <i class="bi bi-inbox display-1 text-muted"></i>
                    </div>
                    <h3 class="fw-light mb-3">No Items Available</h3>
                    <p class="text-muted lead mb-4">This collection doesn't have any items available at the moment.</p>
                    <a href="{{ route('collections') }}" class="btn btn-primary btn-lg px-4 py-3">
                        <i class="bi bi-arrow-left me-2"></i>Browse Other Collections
                    </a>
                </div>
            </div>
        </section>
    @endif

    <!-- Related Seasons -->
    @if($relatedSeasons->count() > 0)
        <section class="py-5 bg-light">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Explore Other Collections</h2>
                    <p class="text-muted lead">Discover more seasonal yarn selections</p>
                </div>
                
                <div class="row g-4">
                    @foreach($relatedSeasons as $index => $relatedSeason)
                        <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="related-season-card h-100 p-4 rounded shadow-sm border-0 bg-white text-center">
                                <div class="season-icon mb-3">
                                    @if($relatedSeason->image_path)
                                        <img src="{{ $relatedSeason->image_path }}" class="img-fluid rounded mb-3" alt="{{ $relatedSeason->code }} Collection" style="max-height: 120px;">
                                    @else
                                        <i class="bi bi-{{ $relatedSeason->half === 'AW' ? 'snow' : 'sun' }} display-4 text-primary"></i>
                                    @endif
                                </div>
                                <h5 class="fw-semibold mb-3">{{ $relatedSeason->code }}</h5>
                                <p class="text-muted small mb-3">{{ $relatedSeason->label }}</p>
                                <a href="{{ route('collection.detail', $relatedSeason->code) }}" class="btn btn-outline-primary btn-sm">
                                    <i class="bi bi-arrow-right me-1"></i>Explore
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Call to Action -->
    <section class="py-5 bg-primary text-white">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <div class="cta-content" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-4">Ready to Start Your Project?</h2>
                        <p class="lead mb-4 opacity-90">
                            Browse our {{ $season->code }} collection organized by category to find the perfect yarns for your next creation.
                        </p>
                        <div class="d-flex gap-3 justify-content-center flex-wrap">
                            <a href="{{ route('collections') }}" class="btn btn-light btn-lg px-4 py-3">
                                <i class="bi bi-collection me-2"></i>View All Collections
                            </a>
                            <a href="/" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-house me-2"></i>Back to Home
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new collections, exclusive releases, and expert yarn insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
