<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vat_analyses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('receipt_line_id')->constrained('receipt_lines')->cascadeOnDelete();
            $table->enum('jurisdiction', ['UK', 'EU', 'Other'])->default('UK');
            $table->decimal('vat_rate', 5, 2)->nullable();
            $table->decimal('vat_amount_claimable', 12, 2)->default(0);
            $table->text('reasoning')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vat_analyses');
    }
};
