<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('statement_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('statement_id')->constrained()->cascadeOnDelete();
            $table->string('cardholder_name');
            $table->string('account_number_last4', 8)->index();
            $table->date('transaction_date')->index();
            $table->string('merchant_name')->index();
            $table->decimal('amount', 12, 2);
            $table->string('currency', 8)->default('GBP');
            $table->decimal('original_amount', 12, 2)->nullable();
            $table->string('original_currency', 8)->nullable();
            $table->decimal('conversion_rate', 16, 6)->nullable();
            $table->date('posted_date')->nullable();
            $table->string('transaction_time')->nullable();
            $table->string('authorisation_code')->nullable();
            $table->string('transaction_id_ref')->nullable()->index();
            $table->string('merchant_category')->nullable();
            $table->string('transaction_type')->nullable();
            $table->string('mcc_description')->nullable();
            $table->string('merchant_city')->nullable();
            $table->string('merchant_state')->nullable();
            $table->string('merchant_postcode')->nullable();
            $table->string('mcc')->nullable();
            $table->boolean('receipt_flag')->default(false);
            $table->string('details')->nullable();
            $table->string('department_hint')->nullable();
            $table->string('account_hint')->nullable();
            $table->foreignId('matched_receipt_id')->nullable()->constrained('receipts')->nullOnDelete();
            $table->timestamps();

            $table->index(['transaction_date', 'amount']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('statement_transactions');
    }
};


