<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// ExFty History API endpoint
Route::get('/exfty-history/{shipmentLineId}', function ($shipmentLineId) {
    $history = \DB::table('audits')
        ->where('auditable_type', 'App\\Models\\ShipmentLine')
        ->where('auditable_id', $shipmentLineId)
        ->whereRaw("JSON_CONTAINS_PATH(old_values, 'one', '$.exfty')")
        ->select([
            'created_at',
            \DB::raw("JSON_UNQUOTE(JSON_EXTRACT(old_values, '$.exfty')) as old_exfty"),
            \DB::raw("JSON_UNQUOTE(JSON_EXTRACT(new_values, '$.exfty')) as new_exfty")
        ])
        ->orderBy('created_at', 'asc')
        ->get();

    // Add current exfty as the latest entry if it exists
    $currentExfty = \App\Models\ShipmentLine::find($shipmentLineId)?->exfty;
    if ($currentExfty) {
        $history->push((object) [
            'created_at' => now(),
            'old_exfty' => $history->last()?->new_exfty ?? null,
            'new_exfty' => $currentExfty
        ]);
    }

    // Format the response
    $formattedHistory = $history->map(function ($change, $index) {
        return [
            'date' => $change->new_exfty ? date('d M Y', strtotime($change->new_exfty)) : null,
            'is_current' => $index === $history->count() - 1,
            'created_at' => $change->created_at
        ];
    })->filter(function ($item) {
        return $item['date'] !== null;
    });

    return response()->json([
        'history' => $formattedHistory->values()->toArray()
    ]);
})->middleware('auth');
