<?php

namespace App\Http\Controllers\Api\V1;

use App\Contracts\PlaybackService;
use App\Http\Controllers\Controller;
use App\Models\Track;
use Illuminate\Http\Request;

class PlaybackController extends Controller
{
    public function __construct(private readonly PlaybackService $playback)
    {
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'track_id' => ['required', 'uuid'],
            'event' => ['required', 'in:play,complete'],
            'at' => ['nullable', 'date'],
        ]);

        $track = Track::findOrFail($validated['track_id']);
        $event = $this->playback->log($validated['event'], $request->user(), $track, $validated['at'] ?? null);
        return response()->json($event);
    }
}


