<?php

namespace App\Http\Controllers\Api\V1;

use App\Contracts\PlaybackService;
use App\Http\Controllers\Controller;
use App\Http\Requests\PlaybackStoreRequest;
use App\Models\Track;

class PlaybackController extends Controller
{
    public function __construct(private readonly PlaybackService $playback)
    {
        $this->middleware(['auth:sanctum', 'throttle:playback']);
    }

    public function store(PlaybackStoreRequest $request)
    {
        $validated = $request->validated();
        $track = Track::findOrFail($validated['track_id']);
        $event = $this->playback->log($validated['event'], $request->user(), $track, $validated['at'] ?? null);
        return response()->json($event);
    }
}


