<div class="space-y-6">
    @if(auth()->user()->hasRole('finance'))
        <!-- Stats Cards -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="stat-card card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="stat-label">Open Statements</div>
                        <div class="stat-value">{{ $financeStats['open_statements'] ?? 0 }}</div>
                    </div>
                    <div class="w-12 h-12 bg-primary-100 dark:bg-primary-900/30 rounded-xl flex items-center justify-center">
                        <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                </div>
            </div>
            
            <div class="stat-card card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="stat-label">Unmatched Receipts</div>
                        <div class="stat-value">{{ $financeStats['unmatched_receipts'] ?? 0 }}</div>
                    </div>
                    <div class="w-12 h-12 bg-warning-100 dark:bg-warning-900/30 rounded-xl flex items-center justify-center">
                        <svg class="w-6 h-6 text-warning-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                        </svg>
                    </div>
                </div>
            </div>
            
            <div class="stat-card card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="stat-label">Quick Actions</div>
                        <div class="mt-3 space-y-2">
                            <a href="{{ route('finance.statements.import') }}" class="btn-primary text-sm px-4 py-2">Import Statement</a>
                            <a href="{{ route('user.receipts.upload') }}" class="btn-accent text-sm px-4 py-2">Upload Receipt</a>
                        </div>
                    </div>
                    <div class="w-12 h-12 bg-accent-100 dark:bg-accent-900/30 rounded-xl flex items-center justify-center">
                        <svg class="w-6 h-6 text-accent-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Recent Transactions -->
        <div class="card">
            <div class="p-6 border-b border-border-light dark:border-border-dark">
                <h3 class="text-lg font-semibold text-secondary-900 dark:text-secondary-100">Recent Transactions</h3>
            </div>
            <div class="overflow-x-auto">
                <table class="table">
                    <thead>
                        <tr class="table-header">
                            <th class="table-cell">Date</th>
                            <th class="table-cell">Merchant</th>
                            <th class="table-cell">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse(($financeStats['recent_transactions'] ?? []) as $txn)
                            <tr class="table-row">
                                <td class="table-cell">{{ $txn->transaction_date?->format('Y-m-d') }}</td>
                                <td class="table-cell font-medium">{{ $txn->merchant_name }}</td>
                                <td class="table-cell font-semibold text-primary-600 dark:text-primary-400">{{ number_format($txn->amount,2) }} {{ $txn->currency }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td class="table-cell text-center text-secondary-500 dark:text-secondary-400" colspan="3">
                                    <div class="py-8">
                                        <svg class="w-12 h-12 mx-auto text-secondary-300 dark:text-secondary-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                        <p>No recent transactions</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <!-- User Dashboard -->
        <div class="card">
            <div class="p-6 border-b border-border-light dark:border-border-dark">
                <h3 class="text-lg font-semibold text-secondary-900 dark:text-secondary-100">Quick Actions</h3>
            </div>
            <div class="p-6">
                <a href="{{ route('user.receipts.upload') }}" class="btn-primary">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                    </svg>
                    Upload Receipt
                </a>
            </div>
        </div>
        
        <div class="card">
            <div class="p-6 border-b border-border-light dark:border-border-dark">
                <h3 class="text-lg font-semibold text-secondary-900 dark:text-secondary-100">My Recent Receipts</h3>
            </div>
            <div class="overflow-x-auto">
                <table class="table">
                    <thead>
                        <tr class="table-header">
                            <th class="table-cell">Date</th>
                            <th class="table-cell">Merchant</th>
                            <th class="table-cell">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse(($userStats['my_receipts'] ?? []) as $r)
                            <tr class="table-row">
                                <td class="table-cell">{{ $r->receipt_date?->format('Y-m-d') }}</td>
                                <td class="table-cell font-medium">{{ $r->merchant_name }}</td>
                                <td class="table-cell font-semibold text-success-600 dark:text-success-400">{{ number_format($r->total_amount,2) }} {{ $r->currency }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td class="table-cell text-center text-secondary-500 dark:text-secondary-400" colspan="3">
                                    <div class="py-8">
                                        <svg class="w-12 h-12 mx-auto text-secondary-300 dark:text-secondary-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                        <p>No receipts yet</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    @endif
</div>
