<div class="space-y-6">
    @if(auth()->user()->hasRole('finance'))
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div class="p-4 bg-white dark:bg-gray-800 rounded shadow">
                <div class="text-sm text-gray-500">Open Statements</div>
                <div class="text-2xl font-semibold">{{ $financeStats['open_statements'] ?? 0 }}</div>
            </div>
            <div class="p-4 bg-white dark:bg-gray-800 rounded shadow">
                <div class="text-sm text-gray-500">Unmatched Receipts</div>
                <div class="text-2xl font-semibold">{{ $financeStats['unmatched_receipts'] ?? 0 }}</div>
            </div>
            <div class="p-4 bg-white dark:bg-gray-800 rounded shadow">
                <div class="text-sm text-gray-500">Actions</div>
                <div class="mt-2 space-x-2">
                    <a class="text-blue-600 underline" href="{{ route('finance.statements.import') }}">Import Statement</a>
                    <a class="text-blue-600 underline" href="{{ route('user.receipts.upload') }}">Upload Receipt</a>
                </div>
            </div>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded shadow p-4">
            <div class="font-medium mb-2">Recent Transactions</div>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left">
                            <th class="px-3 py-2">Date</th>
                            <th class="px-3 py-2">Merchant</th>
                            <th class="px-3 py-2">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse(($financeStats['recent_transactions'] ?? []) as $txn)
                            <tr class="border-t">
                                <td class="px-3 py-2">{{ $txn->transaction_date?->format('Y-m-d') }}</td>
                                <td class="px-3 py-2">{{ $txn->merchant_name }}</td>
                                <td class="px-3 py-2">{{ number_format($txn->amount,2) }} {{ $txn->currency }}</td>
                            </tr>
                        @empty
                            <tr><td class="px-3 py-2 text-sm text-gray-500" colspan="3">No recent transactions.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="p-4 bg-white dark:bg-gray-800 rounded shadow">
            <div class="font-medium mb-2">Quick Actions</div>
            <a class="text-blue-600 underline" href="{{ route('user.receipts.upload') }}">Upload Receipt</a>
        </div>
        <div class="bg-white dark:bg-gray-800 rounded shadow p-4">
            <div class="font-medium mb-2">My Recent Receipts</div>
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left">
                            <th class="px-3 py-2">Date</th>
                            <th class="px-3 py-2">Merchant</th>
                            <th class="px-3 py-2">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse(($userStats['my_receipts'] ?? []) as $r)
                            <tr class="border-t">
                                <td class="px-3 py-2">{{ $r->receipt_date?->format('Y-m-d') }}</td>
                                <td class="px-3 py-2">{{ $r->merchant_name }}</td>
                                <td class="px-3 py-2">{{ number_format($r->total_amount,2) }} {{ $r->currency }}</td>
                            </tr>
                        @empty
                            <tr><td class="px-3 py-2 text-sm text-gray-500" colspan="3">No receipts yet.</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    @endif
</div>
