<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statement_lines', function (Blueprint $table) {
            $table->id();
            $table->foreignId('statement_id')->constrained()->cascadeOnDelete();
            $table->date('transaction_date')->nullable();
            $table->date('posted_date')->nullable();
            $table->string('transaction_time')->nullable();
            $table->string('merchant_name')->nullable();
            $table->decimal('amount', 12, 2)->nullable();
            $table->string('currency', 3)->nullable();
            $table->decimal('original_amount', 12, 2)->nullable();
            $table->string('original_currency', 3)->nullable();
            $table->decimal('conversion_rate', 12, 6)->nullable();
            $table->string('authorisation_code')->nullable();
            $table->string('transaction_id_ext')->nullable();
            $table->string('merchant_category')->nullable();
            $table->string('transaction_type')->nullable();
            $table->string('mcc_description')->nullable();
            $table->string('merchant_city')->nullable();
            $table->string('merchant_state')->nullable();
            $table->string('merchant_postcode')->nullable();
            $table->string('mcc')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->index(['statement_id', 'transaction_date']);
            $table->index(['merchant_name']);
            $table->index(['amount', 'currency']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statement_lines');
    }
};
