<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl font-heading text-neutral-800 leading-tight">
                {{ __('Manage Categories') }}
            </h2>
            <button class="bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 text-white px-4 py-2 rounded-full transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg">
                Add Category
            </button>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Categories Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($categories as $category)
                    <div class="bg-white rounded-2xl shadow-md border border-neutral-200 overflow-hidden hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01]">
                        <div class="p-6">
                            <div class="flex items-center justify-between mb-4">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-primary-100 rounded-xl flex items-center justify-center">
                                        <span class="text-2xl">{{ $category->icon }}</span>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-semibold font-heading text-neutral-900">{{ $category->name }}</h3>
                                        <p class="text-sm text-neutral-500">{{ $category->tracks_count }} tracks</p>
                                    </div>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                        @if($category->color === 'primary') bg-primary-100 text-primary-800
                                        @elseif($category->color === 'accent') bg-accent-100 text-accent-800
                                        @else bg-neutral-100 text-neutral-800 @endif">
                                        {{ ucfirst($category->color) }}
                                    </span>
                                </div>
                            </div>
                            
                            <p class="text-neutral-600 text-sm mb-4">{{ $category->description }}</p>
                            
                            <div class="flex items-center justify-between">
                                <span class="text-xs text-neutral-500">Sort: {{ $category->sort_order }}</span>
                                <div class="flex space-x-2">
                                    <button class="text-primary-600 hover:text-primary-700 text-sm font-medium">
                                        Edit
                                    </button>
                                    <button class="text-red-600 hover:text-red-700 text-sm font-medium">
                                        Delete
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Empty State -->
            @if($categories->count() === 0)
                <div class="text-center py-12">
                    <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-neutral-100 mb-4">
                        <svg class="h-8 w-8 text-neutral-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-medium text-neutral-900 mb-2">No categories yet</h3>
                    <p class="text-neutral-600 mb-4">Get started by creating your first wellness category.</p>
                    <button class="bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 text-white px-6 py-2 rounded-full transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg">
                        Create Category
                    </button>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>
