<?php

namespace App\Http\Controllers;

use App\Models\Profile;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    public function show(Request $request)
    {
        $profile = Profile::firstOrCreate(['user_id' => $request->user()->id]);
        return response()->json($profile);
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'display_name' => ['sometimes', 'string', 'max:255'],
            'goals' => ['sometimes', 'array'],
            'voice_prefs' => ['sometimes', 'array'],
            'sensitivity' => ['sometimes', 'array'],
        ]);

        $profile = Profile::firstOrCreate(['user_id' => $request->user()->id]);
        $profile->update($data);
        return response()->json($profile);
    }
}


