<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProfileUpdateRequest;
use App\Models\Profile;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    public function show(Request $request)
    {
        $profile = Profile::firstOrCreate(['user_id' => $request->user()->id]);

        return response()->json($profile);
    }

    public function update(ProfileUpdateRequest $request)
    {
        $data = $request->validated();
        $profile = Profile::firstOrCreate(['user_id' => $request->user()->id]);
        $profile->update($data);

        return response()->json($profile);
    }
}
