<?php

namespace App\Livewire\Manage;

use Livewire\Component;
use App\Models\Statement;

class Dashboard extends Component
{
    public function render()
    {
        $incompleteStatements = Statement::where('status', 'open')
            ->withCount([
                'transactions as matched_count' => function($q) {
                    $q->whereHas('matches');
                },
                'transactions as total_count'
            ])
            ->latest('period_end')
            ->get();

        $statementsToComplete = $incompleteStatements->count();

        return view('livewire.manage.dashboard', compact(
            'statementsToComplete',
            'incompleteStatements'
        ));
    }
}


