<?php

namespace App\Livewire\Manage;

use Livewire\Component;
use App\Models\Statement;

class Dashboard extends Component
{
    public function render()
    {
        $baseQuery = Statement::query()->where('status', 'open');
        $statementsToComplete = (clone $baseQuery)->count();

        $incompleteStatements = (clone $baseQuery)
            ->withCount([
                'transactions as matched_count' => function($q) {
                    $q->whereHas('matches');
                },
                'transactions as total_count',
                'transactions as unmatched_count' => function($q) {
                    $q->doesntHave('matches');
                },
            ])
            ->orderBy('period_end', 'asc')
            ->take(10)
            ->get();

        $hasMore = $statementsToComplete > $incompleteStatements->count();

        return view('livewire.manage.dashboard', compact(
            'statementsToComplete',
            'incompleteStatements',
            'hasMore'
        ));
    }
}


