<?php

namespace App\Livewire\Manage;

use Livewire\Component;
use App\Models\Receipt;
use App\Models\Statement;
use App\Models\StatementTransaction;

class Dashboard extends Component
{
    public function render()
    {
        $openStatements = Statement::where('status', 'open')->count();
        $receiptsThisMonth = Receipt::whereMonth('receipt_date', now()->month)
            ->whereYear('receipt_date', now()->year)
            ->count();
        $unmatchedReceipts = Receipt::doesntHave('matches')->count();
        $unmatchedTransactions = StatementTransaction::doesntHave('matches')->count();

        return view('livewire.manage.dashboard', compact(
            'openStatements', 'receiptsThisMonth', 'unmatchedReceipts', 'unmatchedTransactions'
        ));
    }
}


