<?php
$meta = [
  'title' => 'Website Design Newcastle (Joomla Specialist)',
  'description' => 'Website design that brings in enquiries. Fast, clear Joomla sites you can update easily.',
  'canonical' => 'https://neilwiddowson.co.uk/services/website-design.php'
];
$currentPage = 'services';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">Website design that brings in enquiries.</h1>
    <p class="mt-4 text-gray-700">Stop losing work to confusing websites. I build clear, fast sites on Joomla — so you can edit pages easily without breaking things.</p>
    
    <div class="mt-8 grid gap-8 lg:grid-cols-2">
      <div>
        <h2 class="text-xl font-semibold text-gray-900 mb-4">Why choose Joomla?</h2>
        <ul class="space-y-3 text-gray-700">
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Easy to update content without breaking the design</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Built-in SEO features that actually work</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Secure and reliable - no monthly fees</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Perfect for local businesses in Newcastle & North East</span>
          </li>
        </ul>
      </div>
      
      <div>
        <h2 class="text-xl font-semibold text-gray-900 mb-4">What you get</h2>
        <ul class="space-y-3 text-gray-700">
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Mobile-first, lightning-fast loading</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Clear copy that converts visitors to customers</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Contact forms and Google Analytics setup</span>
          </li>
          <li class="flex items-start gap-3">
            <svg class="h-5 w-5 text-accent-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
            </svg>
            <span>Training so you can update content yourself</span>
          </li>
        </ul>
      </div>
    </div>

    <div class="mt-12">
      <h2 class="text-2xl font-bold text-gray-900 mb-6">Website Design Pricing</h2>
      <div class="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
        <div class="pricing-card">
          <h3 class="text-lg font-semibold text-gray-900">Lightning Fast Single Page</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">£199</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Mobile-first, lightning-fast loading</li>
            <li>Contact form & basic SEO included</li>
            <li>2 revisions & 1 week delivery</li>
            <li>Perfect for local businesses</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Get started</a></div>
        </div>
        <div class="pricing-card pricing-featured">
          <h3 class="text-lg font-semibold text-gray-900">SEO-Optimized Business Site</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">£799</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Up to 5 pages with advanced SEO</li>
            <li>Mobile-responsive & fast-loading</li>
            <li>4 revisions & professional copy</li>
            <li>Google Analytics & search optimization</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Build my site</a></div>
        </div>
        <div class="pricing-card">
          <h3 class="text-lg font-semibold text-gray-900">Custom Enterprise Solutions</h3>
          <p class="mt-1 text-3xl font-bold text-gray-900">Enquire for pricing</p>
          <ul class="mt-4 space-y-2 text-sm text-gray-700 list-disc list-inside">
            <li>Word-like easy editing system</li>
            <li>Event booking & custom plugins</li>
            <li>Advanced features & integrations</li>
            <li>Tailored to your business needs</li>
          </ul>
          <div class="mt-auto pt-6"><a href="/contact/" class="btn-primary w-full">Get custom quote</a></div>
        </div>
      </div>
    </div>

    <div class="mt-12 text-center">
      <h2 class="text-xl font-semibold text-gray-900 mb-4">Ready to get started?</h2>
      <p class="text-gray-600 mb-6">Every project gets a fixed quote after a quick call. No surprises, no hidden costs.</p>
      <div class="flex flex-col sm:flex-row gap-3 justify-center">
        <a class="btn-primary" href="/contact/">Get a free quote</a>
        <a class="btn-secondary" href="/portfolio/">View portfolio</a>
      </div>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
