-- Migration: Add Stripe columns to subscription_tiers table
-- These columns may be missing if the table was created before this migration

-- Add stripe_price_id column if it doesn't exist
DO $$ 
BEGIN
  IF NOT EXISTS (
    SELECT 1 FROM information_schema.columns 
    WHERE table_name = 'subscription_tiers' 
    AND column_name = 'stripe_price_id'
  ) THEN
    ALTER TABLE subscription_tiers ADD COLUMN stripe_price_id TEXT;
    CREATE INDEX IF NOT EXISTS idx_subscription_tiers_stripe_price_id ON subscription_tiers(stripe_price_id);
    COMMENT ON COLUMN subscription_tiers.stripe_price_id IS 'Stripe Price ID for recurring subscription (e.g., price_xxxxx)';
  END IF;
END $$;

-- Add stripe_product_id column if it doesn't exist
DO $$ 
BEGIN
  IF NOT EXISTS (
    SELECT 1 FROM information_schema.columns 
    WHERE table_name = 'subscription_tiers' 
    AND column_name = 'stripe_product_id'
  ) THEN
    ALTER TABLE subscription_tiers ADD COLUMN stripe_product_id TEXT;
    COMMENT ON COLUMN subscription_tiers.stripe_product_id IS 'Stripe Product ID (e.g., prod_xxxxx)';
  END IF;
END $$;

-- Add currency column if it doesn't exist
DO $$ 
BEGIN
  IF NOT EXISTS (
    SELECT 1 FROM information_schema.columns 
    WHERE table_name = 'subscription_tiers' 
    AND column_name = 'currency'
  ) THEN
    ALTER TABLE subscription_tiers ADD COLUMN currency TEXT NOT NULL DEFAULT 'gbp';
  END IF;
END $$;

-- Add trial_days column if it doesn't exist (might be missing too)
DO $$ 
BEGIN
  IF NOT EXISTS (
    SELECT 1 FROM information_schema.columns 
    WHERE table_name = 'subscription_tiers' 
    AND column_name = 'trial_days'
  ) THEN
    ALTER TABLE subscription_tiers ADD COLUMN trial_days INTEGER NOT NULL DEFAULT 0;
  END IF;
END $$;

-- Add is_featured column if it doesn't exist
DO $$ 
BEGIN
  IF NOT EXISTS (
    SELECT 1 FROM information_schema.columns 
    WHERE table_name = 'subscription_tiers' 
    AND column_name = 'is_featured'
  ) THEN
    ALTER TABLE subscription_tiers ADD COLUMN is_featured BOOLEAN NOT NULL DEFAULT FALSE;
  END IF;
END $$;

-- Add max_albums column if it doesn't exist
DO $$ 
BEGIN
  IF NOT EXISTS (
    SELECT 1 FROM information_schema.columns 
    WHERE table_name = 'subscription_tiers' 
    AND column_name = 'max_albums'
  ) THEN
    ALTER TABLE subscription_tiers ADD COLUMN max_albums INTEGER;
  END IF;
END $$;

-- Add custom_domain_enabled column if it doesn't exist (old column name compatibility)
DO $$ 
BEGIN
  IF NOT EXISTS (
    SELECT 1 FROM information_schema.columns 
    WHERE table_name = 'subscription_tiers' 
    AND column_name = 'custom_domain_enabled'
  ) THEN
    -- Check if allows_custom_domain exists and use that value
    IF EXISTS (
      SELECT 1 FROM information_schema.columns 
      WHERE table_name = 'subscription_tiers' 
      AND column_name = 'allows_custom_domain'
    ) THEN
      ALTER TABLE subscription_tiers ADD COLUMN custom_domain_enabled BOOLEAN;
      UPDATE subscription_tiers SET custom_domain_enabled = allows_custom_domain;
      ALTER TABLE subscription_tiers ALTER COLUMN custom_domain_enabled SET NOT NULL;
      ALTER TABLE subscription_tiers ALTER COLUMN custom_domain_enabled SET DEFAULT FALSE;
    ELSE
      ALTER TABLE subscription_tiers ADD COLUMN custom_domain_enabled BOOLEAN NOT NULL DEFAULT FALSE;
    END IF;
  END IF;
END $$;


