<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        $user = User::factory()->create([
            'name' => 'Test User',
            'email' => 'test@example.com',
        ]);
        \App\Models\Profile::factory()->create(['user_id' => $user->id]);

        $sleep = \App\Models\LibraryCategory::create(['name' => 'Sleep', 'slug' => 'sleep']);
        \App\Models\LibraryTrack::create([
            'category_id' => $sleep->id,
            'title' => 'Deep Sleep Session',
            'slug' => 'deep-sleep-session',
            'duration_sec' => 1200,
            'audio_path' => 'library/sleep/deep-sleep.mp3',
            'transcript_path' => 'library/sleep/deep-sleep.txt',
            'tags' => ['sleep', 'relaxation'],
            'published_at' => now(),
        ]);
    }
}
