<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        $user = User::firstOrCreate(
            ['email' => 'test@example.com'],
            [
                'name' => 'Test User',
                'password_hash' => Hash::make('password'),
            ]
        );
        \App\Models\Profile::firstOrCreate(['user_id' => $user->id]);

        $sleep = \App\Models\LibraryCategory::firstOrCreate(['slug' => 'sleep'], ['name' => 'Sleep']);
        \App\Models\LibraryTrack::firstOrCreate(
            ['slug' => 'deep-sleep-session'],
            [
                'category_id' => $sleep->id,
                'title' => 'Deep Sleep Session',
                'duration_sec' => 1200,
                'audio_path' => 'library/sleep/deep-sleep.mp3',
                'transcript_path' => 'library/sleep/deep-sleep.txt',
                'tags' => ['sleep', 'relaxation'],
                'published_at' => now(),
            ]
        );
    }
}
